/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.core;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FlippingExecutionContext {
    private transient Map<String, Object> parameters = new HashMap<String, Object>();

    public FlippingExecutionContext() {
    }

    public FlippingExecutionContext(Map<String, Object> init) {
        this.parameters = init;
    }

    public Object getValue(String key, boolean required) {
        if (!this.parameters.containsKey(key)) {
            if (required) {
                throw new IllegalArgumentException("Parameter '" + key + "' has not been found but it's required to evaluate strategy");
            }
            return null;
        }
        return this.parameters.get(key);
    }

    public boolean containsKey(String key) {
        return this.parameters.containsKey(key);
    }

    public void addValue(String key, Object value) {
        this.parameters.put(key, value);
    }

    public String getString(String key, boolean required) {
        Object o = this.getValue(key, required);
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("Cannot convert parameter to String it's " + o.getClass());
        }
        return (String)o;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public Boolean getBoolean(String key, boolean required) {
        Object o = this.getValue(key, required);
        if (!(o instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot convert parameter to Boolean it's " + o.getClass());
        }
        return (Boolean)o;
    }

    public Integer getInt(String key) {
        return this.getInt(key, false);
    }

    public Integer getInt(String key, boolean required) {
        Object o = this.getValue(key, required);
        if (!(o instanceof Integer)) {
            throw new IllegalArgumentException("Cannot convert parameter to Integer it's " + o.getClass());
        }
        return (Integer)o;
    }

    public Double getDouble(String key) {
        return this.getDouble(key, false);
    }

    public Double getDouble(String key, boolean required) {
        Object o = this.getValue(key, required);
        if (!(o instanceof Double)) {
            throw new IllegalArgumentException("Cannot convert parameter to Double it's " + o.getClass());
        }
        return (Double)o;
    }

    public Date getDate(String key) {
        return this.getDate(key, false);
    }

    public Date getDate(String key, boolean required) {
        Object o = this.getValue(key, required);
        if (!(o instanceof Date)) {
            throw new IllegalArgumentException("Cannot convert parameter to Date it's " + o.getClass());
        }
        return (Date)o;
    }

    public String getString(String key) {
        return this.getString(key, false);
    }

    public void putString(String key, String value) {
        this.addValue(key, value);
    }

    public void putBoolean(String key, Boolean value) {
        this.addValue(key, value);
    }

    public void putDate(String key, Date value) {
        this.addValue(key, value);
    }

    public void putInt(String key, Integer value) {
        this.addValue(key, value);
    }

    public void putDouble(String key, Double value) {
        this.addValue(key, value);
    }
}

