/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.ff4j.utils.Util;

public abstract class AbstractProperty<T>
implements Serializable {
    private static final long serialVersionUID = 4987351300418126366L;
    protected String name;
    protected String description = null;
    protected String type = this.getClass().getCanonicalName();
    protected T value;
    protected Set<T> fixedValues;

    protected AbstractProperty() {
    }

    protected AbstractProperty(String name) {
        Util.assertHasLength(name);
        this.name = name;
    }

    protected AbstractProperty(String name, String value) {
        this(name);
        this.value = this.fromString(value);
    }

    protected AbstractProperty(String name, T value, T ... fixed) {
        this(name);
        this.value = value;
        this.fixedValues = new HashSet<T>(Arrays.asList(fixed));
        if (this.fixedValues != null && !this.fixedValues.isEmpty() && !this.fixedValues.contains(value)) {
            throw new IllegalArgumentException("Invalid value corrects are " + this.fixedValues);
        }
    }

    public void add2FixedValueFromString(String v) {
        this.add2FixedValue(this.fromString(v));
    }

    public void add2FixedValue(T value) {
        if (this.fixedValues == null) {
            this.fixedValues = new HashSet<T>();
        }
        this.fixedValues.add(value);
    }

    public abstract T fromString(String var1);

    public Class<T> parameterizedType() {
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)pt.getActualTypeArguments()[0];
    }

    public String asString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public int asInt() {
        return new Integer(this.asString());
    }

    public double asDouble() {
        return new Double(this.asString());
    }

    public boolean asBoolean() {
        return new Boolean(this.asString());
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setValueFromString(String value) {
        this.value = this.fromString(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<T> getFixedValues() {
        return this.fixedValues;
    }

    public void setFixedValues(Set<T> fixedValues) {
        this.fixedValues = fixedValues;
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        String start = "{\"name\":\"" + this.name + "\",";
        start = start + "\"description\":";
        start = null != this.description ? start + "\"" + this.description + "\"," : start + "null,";
        start = start + "\"type\":\"" + this.getClass().getCanonicalName() + "\",";
        start = start + "\"value\":";
        String sep = "\"";
        if (this.value instanceof Integer || this.value instanceof Double || this.value instanceof Boolean) {
            sep = "";
        }
        start = start + sep + this.value + sep;
        start = start + ",\"fixedValues\":";
        if (this.fixedValues == null) {
            start = start + "null";
        } else {
            start = start + "[";
            boolean first = true;
            for (T fv : this.fixedValues) {
                start = start + (first ? "" : ",");
                start = start + sep + fv.toString() + sep;
                first = false;
            }
            start = start + "]";
        }
        start = start + "}";
        return start;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

