/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ff4j.exception.FeatureAccessException;

public class JdbcUtils {
    private JdbcUtils() {
    }

    public static PreparedStatement buildStatement(Connection sqlConn, String query, String ... params) throws SQLException {
        PreparedStatement ps = sqlConn.prepareStatement(query);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                ps.setString(i + 1, params[i]);
            }
        }
        return ps;
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("An error occur when closing resultset", e);
        }
    }

    public static void closeStatement(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("An error occur when closing statement", e);
        }
    }

    public static void closeConnection(Connection sqlConnection) {
        try {
            if (sqlConnection != null && !sqlConnection.isClosed()) {
                sqlConnection.close();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("An error occur when closing statement", e);
        }
    }

    public static void rollback(Connection sqlConn) {
        try {
            if (!sqlConn.isClosed()) {
                sqlConn.rollback();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("Cannot rollback database, SQL ERROR", e);
        }
    }
}

