/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.ehcache;

import java.io.InputStream;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;

public final class FF4jEhCacheWrapper {
    public static final String CACHENAME_FEATURES = "ff4jCacheFeatures";
    public static final String CACHENAME_PROPERTIES = "ff4jCacheProperties";
    private CacheManager cacheManager;
    private Configuration cacheConfiguration;
    private InputStream cacheConfigurationFile;
    private Cache cacheFeatures = null;
    private Cache cacheProperties = null;

    public FF4jEhCacheWrapper() {
    }

    public FF4jEhCacheWrapper(Configuration cacheConfig) {
        this.cacheConfiguration = cacheConfig;
    }

    public FF4jEhCacheWrapper(String xmlEhCacheConfig) {
        this.cacheConfigurationFile = this.getClass().getClassLoader().getResourceAsStream(xmlEhCacheConfig);
        if (this.cacheConfigurationFile == null) {
            throw new IllegalArgumentException("Cannot find resource '" + xmlEhCacheConfig + "' in classpath, please check path");
        }
    }

    private CacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = null != this.cacheConfiguration ? CacheManager.create((Configuration)this.cacheConfiguration) : (this.cacheConfigurationFile != null ? CacheManager.create((InputStream)this.cacheConfigurationFile) : CacheManager.create());
        }
        return this.cacheManager;
    }

    public Cache getCacheProperties() {
        if (this.cacheProperties == null) {
            if (!this.getCacheManager().cacheExists(CACHENAME_PROPERTIES)) {
                this.getCacheManager().addCache(CACHENAME_PROPERTIES);
            }
            this.cacheProperties = this.getCacheManager().getCache(CACHENAME_PROPERTIES);
        }
        return this.cacheProperties;
    }

    public Cache getCacheFeatures() {
        if (this.cacheFeatures == null) {
            if (!this.getCacheManager().cacheExists(CACHENAME_FEATURES)) {
                this.getCacheManager().addCache(CACHENAME_FEATURES);
            }
            this.cacheFeatures = this.getCacheManager().getCache(CACHENAME_FEATURES);
        }
        return this.cacheFeatures;
    }
}

