/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import org.ff4j.core.Feature;
import org.ff4j.ehcache.FF4jEhCacheWrapper;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;

public class FeatureStoreEhCache
extends AbstractFeatureStore {
    private FF4jEhCacheWrapper wrapper;

    public FeatureStoreEhCache() {
        this.wrapper = new FF4jEhCacheWrapper();
    }

    public FeatureStoreEhCache(Configuration cacheConfig) {
        this.wrapper = new FF4jEhCacheWrapper(cacheConfig);
    }

    public FeatureStoreEhCache(String xmlEhCacheConfig) {
        this.wrapper = new FF4jEhCacheWrapper(xmlEhCacheConfig);
    }

    public boolean exist(String uid) {
        Util.assertParamHasLength((String)uid, (String)"Feature identifier");
        return this.getCache().get((Serializable)((Object)uid)) != null;
    }

    public Feature read(String uid) {
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        return (Feature)this.getCache().get((Serializable)((Object)uid)).getObjectValue();
    }

    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null");
        }
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        this.getCache().put(new Element((Serializable)((Object)fp.getUid()), (Serializable)fp));
    }

    public void enable(String uid) {
        Feature f = this.read(uid);
        f.enable();
        this.update(f);
    }

    public void disable(String uid) {
        Feature f = this.read(uid);
        f.disable();
        this.update(f);
    }

    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        this.getCache().put(new Element((Serializable)((Object)fp.getUid()), (Serializable)fp));
    }

    public Map<String, Feature> readAll() {
        HashMap<String, Feature> myMap = new HashMap<String, Feature>();
        if (this.getCache().getKeys() != null) {
            for (Object key : this.getCache().getKeys()) {
                Element element = this.getCache().get(key);
                if (element == null) continue;
                Feature f = (Feature)this.getCache().get(key).getObjectValue();
                myMap.put((String)key, f);
            }
        }
        return myMap;
    }

    public void delete(String fpId) {
        if (!this.exist(fpId)) {
            throw new FeatureNotFoundException(fpId);
        }
        this.getCache().remove((Serializable)((Object)fpId));
    }

    public void grantRoleOnFeature(String flipId, String roleName) {
        Util.assertParamHasLength((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().add(roleName);
        this.update(f);
    }

    public void removeRoleFromFeature(String flipId, String roleName) {
        Util.assertParamHasLength((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().remove(roleName);
        this.update(f);
    }

    public Map<String, Feature> readGroup(String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        if (group.isEmpty()) {
            throw new GroupNotFoundException(groupName);
        }
        return group;
    }

    public boolean existGroup(String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        return !group.isEmpty();
    }

    public void enableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().enable();
            this.update(uid.getValue());
        }
    }

    public void disableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().disable();
            this.update(uid.getValue());
        }
    }

    public void addToGroup(String featureId, String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName (#2)");
        Feature f = this.read(featureId);
        f.setGroup(groupName);
        this.update(f);
    }

    public void removeFromGroup(String featureId, String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName (#2)");
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Feature f = this.read(featureId);
        f.setGroup(null);
        this.update(f);
    }

    public Set<String> readAllGroups() {
        Map<String, Feature> features = this.readAll();
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            groups.add(uid.getValue().getGroup());
        }
        groups.remove(null);
        return groups;
    }

    private Cache getCache() {
        return this.wrapper.getCacheFeatures();
    }

    public void clear() {
        this.wrapper.getCacheFeatures().removeAll();
    }
}

