/*
 * Decompiled with CFR 0.152.
 */
package org.finra.msd.containers;

import java.io.File;
import java.util.List;
import org.finra.msd.containers.SourceVars;
import org.finra.msd.enums.SourceType;
import org.finra.msd.util.FileUtil;

public class CmdLine {
    private String dataSourceFolder = "";
    private String outputDirectory = "";
    private String runConfigName = "";
    private String data1 = "";
    private String data2 = "";
    private File source1;
    private File source2;
    private SourceType type1;
    private SourceType type2;
    private boolean local;
    private String clusterId;
    private String clusterName;
    private String numExecutors;
    private String executorMemory;
    private String controllerRAM;
    private String numPartitions;
    private String partitionByColumn;
    private String lowerBound;
    private String upperBound;
    private String delimiter = ",";

    public String getDataSourceFolder() {
        return this.dataSourceFolder;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getRunConfigName() {
        return this.runConfigName;
    }

    public String getData1() {
        return this.data1;
    }

    public String getData2() {
        return this.data2;
    }

    public File getSource1() {
        return this.source1;
    }

    public File getSource2() {
        return this.source2;
    }

    public SourceType getType1() {
        return this.type1;
    }

    public SourceType getType2() {
        return this.type2;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getNumExecutors() {
        return this.numExecutors;
    }

    public String getExecutorMemory() {
        return this.executorMemory;
    }

    public String getControllerRAM() {
        return this.controllerRAM;
    }

    public String getNumPartitions() {
        return this.numPartitions;
    }

    public String getPartitionByColumn() {
        return this.partitionByColumn;
    }

    public String getLowerBound() {
        return this.lowerBound;
    }

    public String getUpperBound() {
        return this.upperBound;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public CmdLine(String[] args) {
        block20: for (int i = 0; i < args.length; ++i) {
            String cur = args[i];
            if (cur.startsWith("--")) {
                if (this.data1.isEmpty()) {
                    this.data1 = cur.substring(2);
                    continue;
                }
                if (!this.data2.isEmpty()) continue;
                this.data2 = cur.substring(2);
                continue;
            }
            if (!cur.contains("=") || cur.indexOf("=") != cur.lastIndexOf("=")) continue;
            String before = cur.substring(0, cur.indexOf("="));
            String after = cur.substring(cur.indexOf("=") + 1);
            switch (before) {
                case "-ds": {
                    this.dataSourceFolder = after;
                    continue block20;
                }
                case "-od": {
                    this.outputDirectory = after;
                    continue block20;
                }
                case "-rc": {
                    this.runConfigName = after;
                    continue block20;
                }
                case "-local": {
                    this.local = Boolean.parseBoolean(after);
                    continue block20;
                }
                case "-ci": 
                case "-cluster-id": {
                    this.clusterId = after;
                    continue block20;
                }
                case "-cn": 
                case "-cluster-name": {
                    this.clusterName = after;
                    continue block20;
                }
                case "-delimiter": {
                    this.delimiter = after;
                    continue block20;
                }
            }
        }
        if (!this.runConfigName.isEmpty()) {
            this.parseRunConfig();
        }
        if (this.dataSourceFolder.isEmpty() || this.outputDirectory.isEmpty() || this.data1.isEmpty() || this.data2.isEmpty()) {
            System.out.println("dataSourceFolder: " + this.dataSourceFolder);
            System.out.println("outputDirectory:  " + this.outputDirectory);
            System.out.println("data1:            " + this.data1);
            System.out.println("data2:            " + this.data2);
            System.out.println("must all be populated.");
            System.exit(1);
        }
        this.findSourceFile(this.data1);
        this.findSourceFile(this.data2);
    }

    private void parseRunConfig() {
        File runConfigFile = new File(this.runConfigName);
        List<String> runConfigs = FileUtil.fileToStringList(runConfigFile);
        for (String cur : runConfigs) {
            if (!cur.contains("=") || cur.indexOf("=") != cur.lastIndexOf("=")) continue;
            String before = cur.substring(0, cur.indexOf("="));
            String after = cur.substring(cur.indexOf("=") + 1);
            switch (before) {
                case "numExecutors": {
                    this.numExecutors = after;
                    break;
                }
                case "executorMemory": {
                    this.executorMemory = after;
                    break;
                }
                case "controllerRAM": {
                    this.controllerRAM = after;
                    break;
                }
                case "numPartitions": {
                    this.numPartitions = after;
                    break;
                }
                case "partitionByColumn": {
                    this.partitionByColumn = after;
                    break;
                }
                case "lowerBound": {
                    this.lowerBound = after;
                    break;
                }
                case "upperBound": {
                    this.upperBound = after;
                    break;
                }
            }
        }
    }

    private void findSourceFile(String dataName) {
        File[] files;
        File cmdFile = new File(this.dataSourceFolder);
        for (File file : files = cmdFile.listFiles()) {
            SourceType foundType = CmdLine.fileContains(file, dataName);
            if (foundType == null) continue;
            if (dataName.equals(this.data1)) {
                this.source1 = file;
                this.type1 = foundType;
            } else {
                this.source2 = file;
                this.type2 = foundType;
            }
            return;
        }
    }

    public static SourceType fileContains(File file, String dataName) {
        SourceVars source = new SourceVars(file);
        if (source.getQuery(dataName) != null) {
            return SourceType.valueOf(source.getConnection().toUpperCase());
        }
        return null;
    }
}

