/*
 * Decompiled with CFR 0.152.
 */
package org.finra.msd.sparkcompare;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.finra.msd.containers.AppleTable;
import org.finra.msd.containers.CountResult;
import org.finra.msd.containers.DiffResult;
import org.finra.msd.enums.SourceType;
import org.finra.msd.implicits.DataFrameImplicits$;
import org.finra.msd.outputwriters.OutputWriter$;
import org.finra.msd.sparkfactory.SparkFactory$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SparkCompare$ {
    public static SparkCompare$ MODULE$;

    static {
        new SparkCompare$();
    }

    public DiffResult compareFiles(String file1Location, String file2Location) {
        Dataset<Row> left = SparkFactory$.MODULE$.parallelizeTextFile(file1Location);
        Dataset<Row> right = SparkFactory$.MODULE$.parallelizeTextFile(file2Location);
        return this.compareFlatDataFrames(left, right);
    }

    public void compareFileSaveResults(String file1Location, String file2Location, String outputDirectory, boolean singleFileOutput, String delimiter) {
        DiffResult resultPair = this.compareFiles(file1Location, file2Location);
        OutputWriter$.MODULE$.saveResultsToDisk(resultPair.inRightNotInLeft(), resultPair.inRightNotInLeft(), outputDirectory, singleFileOutput, delimiter);
    }

    public void compareAppleTablesSaveResults(AppleTable left, AppleTable right, String outputDirectory, boolean singleFileOutput, String delimiter) {
        DiffResult result = this.compareAppleTables(left, right);
        OutputWriter$.MODULE$.saveResultsToDisk(result.inLeftNotInRight(), result.inRightNotInLeft(), outputDirectory, singleFileOutput, delimiter);
    }

    public boolean compareAppleTablesSaveResultsWithManipulation(AppleTable left, AppleTable right, String outputDirectory, boolean singleFileOutput, String delimiter, Option<String[]> excludeCols, Option<String[]> orderByCols, boolean ascOrder) {
        DiffResult result = this.compareAppleTables(left, right);
        if (!BoxesRunTime.equals((Object)excludeCols.getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0), (Object)BoxesRunTime.boxToInteger((int)0))) {
            result = result.removeCols((String[])excludeCols.get());
        }
        if (!BoxesRunTime.equals((Object)orderByCols.getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0), (Object)BoxesRunTime.boxToInteger((int)0))) {
            result = result.getOrderedResult((String[])orderByCols.get(), ascOrder);
        }
        OutputWriter$.MODULE$.saveResultsToDisk(result.inLeftNotInRight(), result.inRightNotInLeft(), outputDirectory, singleFileOutput, delimiter);
        return result.noDiff();
    }

    public DiffResult compareAppleTables(AppleTable left, AppleTable right) {
        Dataset<Row> flatRight;
        Dataset<Row> flatLeft;
        block28: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block13: {
                                            Dataset<Row> expandRight;
                                            Dataset<Row> expandLeft;
                                            block16: {
                                                block20: {
                                                    block19: {
                                                        block18: {
                                                            block15: {
                                                                SourceType sourceType;
                                                                SourceType sourceType2;
                                                                block17: {
                                                                    block14: {
                                                                        SourceType sourceType3 = left.sourceType();
                                                                        SourceType sourceType4 = SourceType.FILE;
                                                                        if (!(sourceType3 == null ? sourceType4 != null : !((Object)((Object)sourceType3)).equals((Object)sourceType4))) break block13;
                                                                        SourceType sourceType5 = right.sourceType();
                                                                        SourceType sourceType6 = SourceType.FILE;
                                                                        if (!(sourceType5 == null ? sourceType6 != null : !((Object)((Object)sourceType5)).equals((Object)sourceType6))) break block13;
                                                                        expandLeft = left.dataFrame();
                                                                        expandRight = right.dataFrame();
                                                                        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expandLeft.columns())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])expandRight.columns()))) {
                                                                            throw new Exception("Column Names Did Not Match");
                                                                        }
                                                                        SourceType sourceType7 = left.sourceType();
                                                                        SourceType sourceType8 = SourceType.DYNAMODB;
                                                                        if (!(sourceType7 == null ? sourceType8 != null : !((Object)((Object)sourceType7)).equals((Object)sourceType8))) break block14;
                                                                        SourceType sourceType9 = left.sourceType();
                                                                        SourceType sourceType10 = SourceType.JSON;
                                                                        if (sourceType9 != null ? !((Object)((Object)sourceType9)).equals((Object)sourceType10) : sourceType10 != null) break block15;
                                                                    }
                                                                    SourceType sourceType11 = right.sourceType();
                                                                    SourceType sourceType12 = SourceType.DYNAMODB;
                                                                    if (!(sourceType11 == null ? sourceType12 != null : !((Object)((Object)sourceType11)).equals((Object)sourceType12))) break block16;
                                                                    sourceType2 = right.sourceType();
                                                                    sourceType = SourceType.JSON;
                                                                    if (sourceType2 != null) break block17;
                                                                    if (sourceType == null) break block16;
                                                                    break block15;
                                                                }
                                                                if (((Object)((Object)sourceType2)).equals((Object)sourceType)) break block16;
                                                            }
                                                            SourceType sourceType = left.sourceType();
                                                            SourceType sourceType13 = SourceType.DYNAMODB;
                                                            if (!(sourceType == null ? sourceType13 != null : !((Object)((Object)sourceType)).equals((Object)sourceType13))) break block18;
                                                            SourceType sourceType14 = left.sourceType();
                                                            SourceType sourceType15 = SourceType.JSON;
                                                            if (sourceType14 != null ? !((Object)((Object)sourceType14)).equals((Object)sourceType15) : sourceType15 != null) break block19;
                                                        }
                                                        expandRight = SparkFactory$.MODULE$.simpleTableToSimpleJSONFormatTable(expandRight);
                                                        break block16;
                                                    }
                                                    SourceType sourceType = right.sourceType();
                                                    SourceType sourceType16 = SourceType.DYNAMODB;
                                                    if (!(sourceType == null ? sourceType16 != null : !((Object)((Object)sourceType)).equals((Object)sourceType16))) break block20;
                                                    SourceType sourceType17 = right.sourceType();
                                                    SourceType sourceType18 = SourceType.JSON;
                                                    if (sourceType17 != null ? !((Object)((Object)sourceType17)).equals((Object)sourceType18) : sourceType18 != null) break block16;
                                                }
                                                expandLeft = SparkFactory$.MODULE$.simpleTableToSimpleJSONFormatTable(expandLeft);
                                            }
                                            return this.compareSchemaDataFrames(expandLeft, expandRight);
                                        }
                                        flatLeft = left.dataFrame();
                                        flatRight = right.dataFrame();
                                        SourceType sourceType = left.sourceType();
                                        SourceType sourceType19 = SourceType.HIVE;
                                        if (!(sourceType == null ? sourceType19 != null : !((Object)((Object)sourceType)).equals((Object)sourceType19))) break block21;
                                        SourceType sourceType20 = left.sourceType();
                                        SourceType sourceType21 = SourceType.JDBC;
                                        if (sourceType20 != null ? !((Object)((Object)sourceType20)).equals((Object)sourceType21) : sourceType21 != null) break block22;
                                    }
                                    flatLeft = SparkFactory$.MODULE$.flattenDataFrame(left.dataFrame(), left.delimiter());
                                }
                                SourceType sourceType = left.sourceType();
                                SourceType sourceType22 = SourceType.DYNAMODB;
                                if (!(sourceType == null ? sourceType22 != null : !((Object)((Object)sourceType)).equals((Object)sourceType22))) break block23;
                                SourceType sourceType23 = left.sourceType();
                                SourceType sourceType24 = SourceType.JSON;
                                if (sourceType23 != null ? !((Object)((Object)sourceType23)).equals((Object)sourceType24) : sourceType24 != null) break block24;
                            }
                            flatLeft = SparkFactory$.MODULE$.flattenDataFrame(flatLeft, left.delimiter());
                        }
                        SourceType sourceType = right.sourceType();
                        SourceType sourceType25 = SourceType.HIVE;
                        if (!(sourceType == null ? sourceType25 != null : !((Object)((Object)sourceType)).equals((Object)sourceType25))) break block25;
                        SourceType sourceType26 = right.sourceType();
                        SourceType sourceType27 = SourceType.JDBC;
                        if (sourceType26 != null ? !((Object)((Object)sourceType26)).equals((Object)sourceType27) : sourceType27 != null) break block26;
                    }
                    flatRight = SparkFactory$.MODULE$.flattenDataFrame(right.dataFrame(), right.delimiter());
                }
                SourceType sourceType = right.sourceType();
                SourceType sourceType28 = SourceType.DYNAMODB;
                if (!(sourceType == null ? sourceType28 != null : !((Object)((Object)sourceType)).equals((Object)sourceType28))) break block27;
                SourceType sourceType29 = right.sourceType();
                SourceType sourceType30 = SourceType.JSON;
                if (sourceType29 != null ? !((Object)((Object)sourceType29)).equals((Object)sourceType30) : sourceType30 != null) break block28;
            }
            flatRight = SparkFactory$.MODULE$.flattenDataFrame(flatRight, right.delimiter());
        }
        return this.compareFlatDataFrames(flatLeft, flatRight);
    }

    private DiffResult compareFlatDataFrames(Dataset<Row> left, Dataset<Row> right) {
        Dataset leftGrouped = left.groupBy("values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        Dataset rightGrouped = right.groupBy("values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        Dataset inLnotinR = leftGrouped.except(rightGrouped).toDF();
        Dataset inRnotinL = rightGrouped.except(leftGrouped).toDF();
        DiffResult subtractResult = new DiffResult((Dataset<Row>)inLnotinR, (Dataset<Row>)inRnotinL);
        return subtractResult;
    }

    public DiffResult compareSchemaDataFrames(Dataset<Row> left, Dataset<Row> right) {
        Dataset groupedLeft = left.groupBy(DataFrameImplicits$.MODULE$.DataFrameImprovements(left).getColumnsSeq()).count().withColumnRenamed("count", "recordRepeatCount");
        Dataset groupedRight = right.groupBy(DataFrameImplicits$.MODULE$.DataFrameImprovements(right).getColumnsSeq()).count().withColumnRenamed("count", "recordRepeatCount");
        Dataset inLeftNotInRight = groupedLeft.except(groupedRight).toDF();
        Dataset inRightNotInLeft = groupedRight.except(groupedLeft).toDF();
        return new DiffResult((Dataset<Row>)inLeftNotInRight, (Dataset<Row>)inRightNotInLeft);
    }

    public CountResult compareAppleTablesCount(AppleTable left, AppleTable right) {
        long leftCount = left.dataFrame().count();
        long rightCount = right.dataFrame().count();
        return new CountResult(leftCount, rightCount);
    }

    private SparkCompare$() {
        MODULE$ = this;
    }
}

