/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.argument;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.argument.ArgumentType;
import org.firebirdsql.gds.impl.argument.TypedArgument;

public final class ByteArrayArgument
extends TypedArgument {
    private static final long serialVersionUID = -8636439991275911102L;
    private final byte[] value;

    public ByteArrayArgument(int type, ArgumentType argumentType, byte[] value) {
        super(type, argumentType);
        if (argumentType != ArgumentType.TraditionalDpb && argumentType != ArgumentType.Wide && argumentType != ArgumentType.StringSpb) {
            throw new IllegalArgumentException("ByteArrayArgument only works for TraditionalDpb, Wide, or StringSpb was: " + argumentType);
        }
        if (value == null) {
            throw new IllegalArgumentException("byte array value should not be null");
        }
        if (value.length > argumentType.getMaxLength()) {
            throw new IllegalArgumentException(String.format("byte array value should not be longer than %d bytes, length was %d", argumentType.getMaxLength(), value.length));
        }
        this.value = value;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        this.argumentType.writeLength(this.value.length, outputStream);
        outputStream.write(this.value);
    }

    @Override
    public int getLength() {
        return 1 + this.argumentType.getLengthSize() + this.value.length;
    }

    @Override
    public int getValueAsInt() {
        if (this.value.length == 1) {
            return this.value[0];
        }
        throw new UnsupportedOperationException("This method is not supported for byte arrays with length > 1");
    }

    @Override
    public void copyTo(ParameterBuffer buffer, Encoding encoding) {
        buffer.addArgument(this.getType(), (byte[])this.value.clone());
    }

    public boolean equals(Object other) {
        if (!(other instanceof ByteArrayArgument)) {
            return false;
        }
        ByteArrayArgument otherByteArrayArgument = (ByteArrayArgument)other;
        return this.getType() == otherByteArrayArgument.getType() && Arrays.equals(this.value, otherByteArrayArgument.value);
    }

    public int hashCode() {
        int result = 23;
        result = 41 * result + this.getType();
        result = 41 * result + Arrays.hashCode(this.value);
        return result;
    }
}

