/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchBuilder;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchQuery;
import org.flowable.batch.service.impl.BatchBuilderImpl;
import org.flowable.batch.service.impl.BatchQueryImpl;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.management.TableMetaData;
import org.flowable.common.engine.api.management.TablePageQuery;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.cmd.CustomSqlExecution;
import org.flowable.common.engine.impl.cmd.GetPropertiesCmd;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.DbSqlSessionFactory;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.engine.impl.lock.LockManagerImpl;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;
import org.flowable.engine.ManagementService;
import org.flowable.engine.event.EventLogEntry;
import org.flowable.engine.impl.TablePageQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.DeleteBatchCmd;
import org.flowable.engine.impl.cmd.DeleteEventLogEntry;
import org.flowable.engine.impl.cmd.ExecuteCustomSqlCmd;
import org.flowable.engine.impl.cmd.FindBatchPartsByBatchIdCmd;
import org.flowable.engine.impl.cmd.FindBatchesBySearchKeyCmd;
import org.flowable.engine.impl.cmd.GetAllBatchesCmd;
import org.flowable.engine.impl.cmd.GetBatchDocumentCmd;
import org.flowable.engine.impl.cmd.GetBatchPartCmd;
import org.flowable.engine.impl.cmd.GetBatchPartDocumentCmd;
import org.flowable.engine.impl.cmd.GetEventLogEntriesCmd;
import org.flowable.engine.impl.cmd.GetTableCountCmd;
import org.flowable.engine.impl.cmd.GetTableMetaDataCmd;
import org.flowable.engine.impl.cmd.GetTableNameCmd;
import org.flowable.engine.impl.cmd.HandleHistoryCleanupTimerJobCmd;
import org.flowable.engine.impl.cmd.RescheduleTimerJobCmd;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.api.DeadLetterJobQuery;
import org.flowable.job.api.HistoryJobQuery;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobQuery;
import org.flowable.job.api.SuspendedJobQuery;
import org.flowable.job.api.TimerJobQuery;
import org.flowable.job.service.impl.DeadLetterJobQueryImpl;
import org.flowable.job.service.impl.HistoryJobQueryImpl;
import org.flowable.job.service.impl.JobQueryImpl;
import org.flowable.job.service.impl.SuspendedJobQueryImpl;
import org.flowable.job.service.impl.TimerJobQueryImpl;
import org.flowable.job.service.impl.cmd.DeleteDeadLetterJobCmd;
import org.flowable.job.service.impl.cmd.DeleteHistoryJobCmd;
import org.flowable.job.service.impl.cmd.DeleteJobCmd;
import org.flowable.job.service.impl.cmd.DeleteSuspendedJobCmd;
import org.flowable.job.service.impl.cmd.DeleteTimerJobCmd;
import org.flowable.job.service.impl.cmd.ExecuteHistoryJobCmd;
import org.flowable.job.service.impl.cmd.ExecuteJobCmd;
import org.flowable.job.service.impl.cmd.GetJobExceptionStacktraceCmd;
import org.flowable.job.service.impl.cmd.JobType;
import org.flowable.job.service.impl.cmd.MoveDeadLetterJobToExecutableJobCmd;
import org.flowable.job.service.impl.cmd.MoveJobToDeadLetterJobCmd;
import org.flowable.job.service.impl.cmd.MoveSuspendedJobToExecutableJobCmd;
import org.flowable.job.service.impl.cmd.MoveTimerToExecutableJobCmd;
import org.flowable.job.service.impl.cmd.SetJobRetriesCmd;
import org.flowable.job.service.impl.cmd.SetTimerJobRetriesCmd;

public class ManagementServiceImpl
extends CommonEngineServiceImpl<ProcessEngineConfigurationImpl>
implements ManagementService {
    public ManagementServiceImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super((AbstractEngineConfiguration)processEngineConfiguration);
    }

    @Override
    public Map<String, Long> getTableCount() {
        return (Map)this.commandExecutor.execute((Command)new GetTableCountCmd());
    }

    @Override
    public String getTableName(Class<?> entityClass) {
        return (String)this.commandExecutor.execute((Command)new GetTableNameCmd(entityClass));
    }

    @Override
    public String getTableName(Class<?> entityClass, boolean includePrefix) {
        return (String)this.commandExecutor.execute((Command)new GetTableNameCmd(entityClass, includePrefix));
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        return (TableMetaData)this.commandExecutor.execute((Command)new GetTableMetaDataCmd(tableName));
    }

    @Override
    public void executeJob(String jobId) {
        try {
            this.commandExecutor.execute((Command)new ExecuteJobCmd(jobId));
        }
        catch (RuntimeException e) {
            if (e instanceof FlowableException) {
                throw e;
            }
            throw new FlowableException("Job " + jobId + " failed", (Throwable)e);
        }
    }

    @Override
    public void executeHistoryJob(String historyJobId) {
        this.commandExecutor.execute((Command)new ExecuteHistoryJobCmd(historyJobId));
    }

    @Override
    public Job moveTimerToExecutableJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveTimerToExecutableJobCmd(jobId));
    }

    @Override
    public Job moveJobToDeadLetterJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveJobToDeadLetterJobCmd(jobId));
    }

    @Override
    public Job moveDeadLetterJobToExecutableJob(String jobId, int retries) {
        return (Job)this.commandExecutor.execute((Command)new MoveDeadLetterJobToExecutableJobCmd(jobId, retries));
    }

    @Override
    public Job moveSuspendedJobToExecutableJob(String jobId) {
        return (Job)this.commandExecutor.execute((Command)new MoveSuspendedJobToExecutableJobCmd(jobId));
    }

    @Override
    public void deleteJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteJobCmd(jobId));
    }

    @Override
    public void deleteTimerJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteTimerJobCmd(jobId));
    }

    @Override
    public void deleteSuspendedJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteSuspendedJobCmd(jobId));
    }

    @Override
    public void deleteDeadLetterJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteDeadLetterJobCmd(jobId));
    }

    @Override
    public void deleteHistoryJob(String jobId) {
        this.commandExecutor.execute((Command)new DeleteHistoryJobCmd(jobId));
    }

    @Override
    public void setJobRetries(String jobId, int retries) {
        this.commandExecutor.execute((Command)new SetJobRetriesCmd(jobId, retries));
    }

    @Override
    public void setTimerJobRetries(String jobId, int retries) {
        this.commandExecutor.execute((Command)new SetTimerJobRetriesCmd(jobId, retries));
    }

    @Override
    public Job rescheduleTimeDateJob(String jobId, String timeDate) {
        return (Job)this.commandExecutor.execute((Command)new RescheduleTimerJobCmd(jobId, timeDate, null, null, null, null));
    }

    @Override
    public Job rescheduleTimeDurationJob(String jobId, String timeDuration) {
        return (Job)this.commandExecutor.execute((Command)new RescheduleTimerJobCmd(jobId, null, timeDuration, null, null, null));
    }

    @Override
    public Job rescheduleTimeCycleJob(String jobId, String timeCycle) {
        return (Job)this.commandExecutor.execute((Command)new RescheduleTimerJobCmd(jobId, null, null, timeCycle, null, null));
    }

    @Override
    public Job rescheduleTimerJob(String jobId, String timeDate, String timeDuration, String timeCycle, String endDate, String calendarName) {
        return (Job)this.commandExecutor.execute((Command)new RescheduleTimerJobCmd(jobId, timeDate, timeDuration, timeCycle, endDate, calendarName));
    }

    @Override
    public TablePageQuery createTablePageQuery() {
        return new TablePageQueryImpl(this.commandExecutor);
    }

    @Override
    public JobQuery createJobQuery() {
        return new JobQueryImpl(this.commandExecutor);
    }

    @Override
    public TimerJobQuery createTimerJobQuery() {
        return new TimerJobQueryImpl(this.commandExecutor);
    }

    @Override
    public SuspendedJobQuery createSuspendedJobQuery() {
        return new SuspendedJobQueryImpl(this.commandExecutor);
    }

    @Override
    public DeadLetterJobQuery createDeadLetterJobQuery() {
        return new DeadLetterJobQueryImpl(this.commandExecutor);
    }

    @Override
    public HistoryJobQuery createHistoryJobQuery() {
        return new HistoryJobQueryImpl(this.commandExecutor);
    }

    @Override
    public String getJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.ASYNC));
    }

    @Override
    public String getTimerJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.TIMER));
    }

    @Override
    public String getSuspendedJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.SUSPENDED));
    }

    @Override
    public String getDeadLetterJobExceptionStacktrace(String jobId) {
        return (String)this.commandExecutor.execute((Command)new GetJobExceptionStacktraceCmd(jobId, JobType.DEADLETTER));
    }

    @Override
    public void handleHistoryCleanupTimerJob() {
        this.commandExecutor.execute((Command)new HandleHistoryCleanupTimerJobCmd());
    }

    @Override
    public List<Batch> getAllBatches() {
        return (List)this.commandExecutor.execute((Command)new GetAllBatchesCmd());
    }

    @Override
    public List<Batch> findBatchesBySearchKey(String searchKey) {
        return (List)this.commandExecutor.execute((Command)new FindBatchesBySearchKeyCmd(searchKey));
    }

    @Override
    public String getBatchDocument(String batchId) {
        return (String)this.commandExecutor.execute((Command)new GetBatchDocumentCmd(batchId));
    }

    @Override
    public BatchPart getBatchPart(String batchPartId) {
        return (BatchPart)this.commandExecutor.execute((Command)new GetBatchPartCmd(batchPartId));
    }

    @Override
    public List<BatchPart> findBatchPartsByBatchId(String batchId) {
        return (List)this.commandExecutor.execute((Command)new FindBatchPartsByBatchIdCmd(batchId));
    }

    @Override
    public List<BatchPart> findBatchPartsByBatchIdAndStatus(String batchId, String status) {
        return (List)this.commandExecutor.execute((Command)new FindBatchPartsByBatchIdCmd(batchId, status));
    }

    @Override
    public String getBatchPartDocument(String batchPartId) {
        return (String)this.commandExecutor.execute((Command)new GetBatchPartDocumentCmd(batchPartId));
    }

    @Override
    public BatchQuery createBatchQuery() {
        return new BatchQueryImpl(this.commandExecutor);
    }

    @Override
    public BatchBuilder createBatchBuilder() {
        return new BatchBuilderImpl(this.commandExecutor);
    }

    @Override
    public void deleteBatch(String batchId) {
        this.commandExecutor.execute((Command)new DeleteBatchCmd(batchId));
    }

    @Override
    public Map<String, String> getProperties() {
        return (Map)this.commandExecutor.execute((Command)new GetPropertiesCmd());
    }

    @Override
    public String databaseSchemaUpgrade(final Connection connection, final String catalog, final String schema) {
        CommandConfig config = this.commandExecutor.getDefaultConfig().transactionNotSupported();
        return (String)this.commandExecutor.execute(config, (Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                DbSqlSessionFactory dbSqlSessionFactory = (DbSqlSessionFactory)commandContext.getSessionFactories().get(DbSqlSession.class);
                DbSqlSession dbSqlSession = new DbSqlSession(dbSqlSessionFactory, CommandContextUtil.getEntityCache(commandContext), connection, catalog, schema);
                commandContext.getSessions().put(DbSqlSession.class, dbSqlSession);
                return CommandContextUtil.getProcessEngineConfiguration(commandContext).getSchemaManager().schemaUpdate();
            }
        });
    }

    @Override
    public <T> T executeCommand(Command<T> command) {
        if (command == null) {
            throw new FlowableIllegalArgumentException("The command is null");
        }
        return (T)this.commandExecutor.execute(command);
    }

    @Override
    public <T> T executeCommand(CommandConfig config, Command<T> command) {
        if (config == null) {
            throw new FlowableIllegalArgumentException("The config is null");
        }
        if (command == null) {
            throw new FlowableIllegalArgumentException("The command is null");
        }
        return (T)this.commandExecutor.execute(config, command);
    }

    @Override
    public LockManager getLockManager(String lockName) {
        return new LockManagerImpl(this.commandExecutor, lockName, ((ProcessEngineConfigurationImpl)((Object)this.getConfiguration())).getLockPollRate());
    }

    @Override
    public <MapperType, ResultType> ResultType executeCustomSql(CustomSqlExecution<MapperType, ResultType> customSqlExecution) {
        Class mapperClass = customSqlExecution.getMapperClass();
        return (ResultType)this.commandExecutor.execute(new ExecuteCustomSqlCmd<MapperType, ResultType>(mapperClass, customSqlExecution));
    }

    @Override
    public List<EventLogEntry> getEventLogEntries(Long startLogNr, Long pageSize) {
        return (List)this.commandExecutor.execute((Command)new GetEventLogEntriesCmd(startLogNr, pageSize));
    }

    @Override
    public List<EventLogEntry> getEventLogEntriesByProcessInstanceId(String processInstanceId) {
        return (List)this.commandExecutor.execute((Command)new GetEventLogEntriesCmd(processInstanceId));
    }

    @Override
    public void deleteEventLogEntry(long logNr) {
        this.commandExecutor.execute((Command)new DeleteEventLogEntry(logNr));
    }
}

