/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.Task;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.CustomPropertiesResolver;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.delegate.TransactionDependentExecutionListener;
import org.flowable.engine.delegate.TransactionDependentTaskListener;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.AbstractClassDelegate;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.parser.FieldDeclaration;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.delegate.invocation.ExecutionListenerInvocation;
import org.flowable.engine.impl.delegate.invocation.TaskListenerInvocation;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.task.service.delegate.TaskListener;

public class ClassDelegate
extends AbstractClassDelegate
implements TaskListener,
ExecutionListener,
TransactionDependentExecutionListener,
TransactionDependentTaskListener,
SubProcessActivityBehavior,
CustomPropertiesResolver {
    private static final long serialVersionUID = 1L;
    protected ActivityBehavior activityBehaviorInstance;
    protected Expression skipExpression;
    protected List<MapExceptionEntry> mapExceptions;
    protected CustomPropertiesResolver customPropertiesResolverInstance;
    protected boolean triggerable;

    public ClassDelegate(String className, List<FieldDeclaration> fieldDeclarations, Expression skipExpression) {
        super(className, fieldDeclarations);
        this.skipExpression = skipExpression;
    }

    public ClassDelegate(String id, String className, List<FieldDeclaration> fieldDeclarations, boolean triggerable, Expression skipExpression, List<MapExceptionEntry> mapExceptions) {
        this(className, fieldDeclarations, skipExpression);
        this.triggerable = triggerable;
        this.serviceTaskId = id;
        this.mapExceptions = mapExceptions;
    }

    public ClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations, Expression skipExpression) {
        this(clazz.getName(), fieldDeclarations, skipExpression);
    }

    public ClassDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        super(className, fieldDeclarations);
    }

    public ClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        super(clazz, fieldDeclarations);
    }

    @Override
    public void notify(DelegateExecution execution) {
        ExecutionListener executionListenerInstance = this.getExecutionListenerInstance();
        CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(executionListenerInstance, execution));
    }

    @Override
    public void notify(String processInstanceId, String executionId, FlowElement flowElement, Map<String, Object> executionVariables, Map<String, Object> customPropertiesMap) {
        TransactionDependentExecutionListener transactionDependentExecutionListenerInstance = this.getTransactionDependentExecutionListenerInstance();
        transactionDependentExecutionListenerInstance.notify(processInstanceId, executionId, flowElement, executionVariables, customPropertiesMap);
    }

    @Override
    public Map<String, Object> getCustomPropertiesMap(DelegateExecution execution) {
        if (this.customPropertiesResolverInstance == null) {
            this.customPropertiesResolverInstance = this.getCustomPropertiesResolverInstance();
        }
        return this.customPropertiesResolverInstance.getCustomPropertiesMap(execution);
    }

    public void notify(DelegateTask delegateTask) {
        TaskListener taskListenerInstance = this.getTaskListenerInstance();
        try {
            CommandContextUtil.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(taskListenerInstance, delegateTask));
        }
        catch (Exception e) {
            throw new FlowableException("Exception while invoking TaskListener: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void notify(String processInstanceId, String executionId, Task task, Map<String, Object> executionVariables, Map<String, Object> customPropertiesMap) {
        TransactionDependentTaskListener transactionDependentTaskListenerInstance = this.getTransactionDependentTaskListenerInstance();
        transactionDependentTaskListenerInstance.notify(processInstanceId, executionId, task, executionVariables, customPropertiesMap);
    }

    protected ExecutionListener getExecutionListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ExecutionListener) {
            return (ExecutionListener)delegateInstance;
        }
        if (delegateInstance instanceof JavaDelegate) {
            return new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance, this.triggerable, this.skipExpression);
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + ExecutionListener.class + " nor " + JavaDelegate.class);
    }

    protected TransactionDependentExecutionListener getTransactionDependentExecutionListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TransactionDependentExecutionListener) {
            return (TransactionDependentExecutionListener)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + TransactionDependentExecutionListener.class);
    }

    protected CustomPropertiesResolver getCustomPropertiesResolverInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof CustomPropertiesResolver) {
            return (CustomPropertiesResolver)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + CustomPropertiesResolver.class);
    }

    protected TaskListener getTaskListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TaskListener) {
            return (TaskListener)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + TaskListener.class);
    }

    protected TransactionDependentTaskListener getTransactionDependentTaskListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TransactionDependentTaskListener) {
            return (TransactionDependentTaskListener)delegateInstance;
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + TransactionDependentTaskListener.class);
    }

    @Override
    public void execute(DelegateExecution execution) {
        block5: {
            String overrideClassName;
            ObjectNode taskElementProperties;
            if (CommandContextUtil.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskClassName") && StringUtils.isNotEmpty((CharSequence)(overrideClassName = taskElementProperties.get("serviceTaskClassName").asText())) && !overrideClassName.equals(this.className)) {
                this.className = overrideClassName;
                this.activityBehaviorInstance = null;
            }
            if (this.activityBehaviorInstance == null) {
                this.activityBehaviorInstance = this.getActivityBehaviorInstance();
            }
            try {
                this.activityBehaviorInstance.execute(execution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, execution);
            }
            catch (RuntimeException e) {
                if (ErrorPropagation.mapException(e, (ExecutionEntity)execution, this.mapExceptions)) break block5;
                throw e;
            }
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance();
        }
        if (this.activityBehaviorInstance instanceof TriggerableActivityBehavior) {
            ((TriggerableActivityBehavior)this.activityBehaviorInstance).trigger(execution, signalName, signalData);
            if (this.triggerable) {
                this.leave(execution);
            }
        } else {
            throw new FlowableException("signal() can only be called on a " + TriggerableActivityBehavior.class.getName() + " instance");
        }
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance();
        }
        if (!(this.activityBehaviorInstance instanceof SubProcessActivityBehavior)) {
            throw new FlowableException("completing() can only be called on a " + SubProcessActivityBehavior.class.getName() + " instance");
        }
        ((SubProcessActivityBehavior)this.activityBehaviorInstance).completing(execution, subProcessInstance);
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance();
        }
        if (!(this.activityBehaviorInstance instanceof SubProcessActivityBehavior)) {
            throw new FlowableException("completed() can only be called on a " + SubProcessActivityBehavior.class.getName() + " instance");
        }
        ((SubProcessActivityBehavior)this.activityBehaviorInstance).completed(execution);
    }

    protected ActivityBehavior getActivityBehaviorInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            return this.determineBehaviour((ActivityBehavior)delegateInstance);
        }
        if (delegateInstance instanceof JavaDelegate) {
            return this.determineBehaviour(new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance, this.triggerable, this.skipExpression));
        }
        throw new FlowableIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + JavaDelegate.class.getName() + " nor " + ActivityBehavior.class.getName());
    }

    protected ActivityBehavior determineBehaviour(ActivityBehavior delegateInstance) {
        if (this.hasMultiInstanceCharacteristics()) {
            this.multiInstanceActivityBehavior.setInnerActivityBehavior((AbstractBpmnActivityBehavior)delegateInstance);
            return this.multiInstanceActivityBehavior;
        }
        return delegateInstance;
    }
}

