/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.AbstractProcessEngineEntityManager;
import org.flowable.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionInfoEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionInfoEntityManager;
import org.flowable.engine.impl.persistence.entity.data.ProcessDefinitionInfoDataManager;

public class ProcessDefinitionInfoEntityManagerImpl
extends AbstractProcessEngineEntityManager<ProcessDefinitionInfoEntity, ProcessDefinitionInfoDataManager>
implements ProcessDefinitionInfoEntityManager {
    public ProcessDefinitionInfoEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, ProcessDefinitionInfoDataManager processDefinitionInfoDataManager) {
        super(processEngineConfiguration, processDefinitionInfoDataManager);
    }

    @Override
    public void insertProcessDefinitionInfo(ProcessDefinitionInfoEntity processDefinitionInfo) {
        this.insert(processDefinitionInfo);
    }

    @Override
    public void updateProcessDefinitionInfo(ProcessDefinitionInfoEntity updatedProcessDefinitionInfo) {
        this.update(updatedProcessDefinitionInfo, true);
    }

    @Override
    public void deleteProcessDefinitionInfo(String processDefinitionId) {
        ProcessDefinitionInfoEntity processDefinitionInfo = this.findProcessDefinitionInfoByProcessDefinitionId(processDefinitionId);
        if (processDefinitionInfo != null) {
            this.delete(processDefinitionInfo);
            this.deleteInfoJson(processDefinitionInfo);
        }
    }

    @Override
    public void updateInfoJson(String id, byte[] json) {
        ProcessDefinitionInfoEntity processDefinitionInfo = (ProcessDefinitionInfoEntity)this.findById(id);
        if (processDefinitionInfo != null) {
            ByteArrayRef ref = new ByteArrayRef(processDefinitionInfo.getInfoJsonId());
            ref.setValue("json", json);
            if (processDefinitionInfo.getInfoJsonId() == null) {
                processDefinitionInfo.setInfoJsonId(ref.getId());
            }
            this.updateProcessDefinitionInfo(processDefinitionInfo);
        }
    }

    @Override
    public void deleteInfoJson(ProcessDefinitionInfoEntity processDefinitionInfo) {
        if (processDefinitionInfo.getInfoJsonId() != null) {
            ByteArrayRef ref = new ByteArrayRef(processDefinitionInfo.getInfoJsonId());
            ref.delete();
        }
    }

    @Override
    public ProcessDefinitionInfoEntity findProcessDefinitionInfoByProcessDefinitionId(String processDefinitionId) {
        return ((ProcessDefinitionInfoDataManager)this.dataManager).findProcessDefinitionInfoByProcessDefinitionId(processDefinitionId);
    }

    @Override
    public byte[] findInfoJsonById(String infoJsonId) {
        ByteArrayRef ref = new ByteArrayRef(infoJsonId);
        return ref.getBytes();
    }
}

