/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.common.engine.impl.logging.LoggingSessionUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.ServiceTaskDelegateExpressionActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.ServiceTaskExpressionActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ClassDelegate;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class BpmnLoggingSessionUtil {
    public static void addLoggingData(String type, String message, DelegateExecution execution) {
        FlowElement flowElement = execution.getCurrentFlowElement();
        String activityId = null;
        String activityName = null;
        String activityType = null;
        String activitySubType = null;
        if (flowElement != null) {
            activityId = flowElement.getId();
            activityName = flowElement.getName();
            activityType = flowElement.getClass().getSimpleName();
            activitySubType = BpmnLoggingSessionUtil.getActivitySubType(flowElement);
        }
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)execution.getProcessInstanceId(), (String)execution.getId(), (String)"bpmn", (String)execution.getProcessDefinitionId(), (String)activityId, (String)activityName, (String)activityType, (String)activitySubType);
        BpmnLoggingSessionUtil.fillScopeDefinitionInfo(execution.getProcessDefinitionId(), loggingNode);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode);
    }

    public static void addLoggingData(String type, String message, TaskEntity task, DelegateExecution execution) {
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)task.getProcessInstanceId(), (String)task.getExecutionId(), (String)"bpmn");
        loggingNode.put("scopeDefinitionId", execution.getProcessDefinitionId());
        loggingNode.put("taskId", task.getId());
        BpmnLoggingSessionUtil.putIfNotNull("taskName", task.getName(), loggingNode);
        BpmnLoggingSessionUtil.putIfNotNull("taskCategory", task.getCategory(), loggingNode);
        BpmnLoggingSessionUtil.putIfNotNull("taskFormKey", task.getFormKey(), loggingNode);
        BpmnLoggingSessionUtil.putIfNotNull("taskDescription", task.getDescription(), loggingNode);
        BpmnLoggingSessionUtil.putIfNotNull("taskDueDate", task.getDueDate(), loggingNode);
        BpmnLoggingSessionUtil.putIfNotNull("taskPriority", task.getPriority(), loggingNode);
        BpmnLoggingSessionUtil.fillScopeDefinitionInfo(execution.getProcessDefinitionId(), loggingNode);
        BpmnLoggingSessionUtil.fillFlowElementInfo(loggingNode, execution);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode);
    }

    public static void addExecuteActivityBehaviorLoggingData(String type, ActivityBehavior activityBehavior, FlowNode flowNode, ExecutionEntity execution) {
        String message = "In " + flowNode.getClass().getSimpleName() + ", executing " + activityBehavior.getClass().getSimpleName();
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)execution.getProcessInstanceId(), (String)execution.getId(), (String)"bpmn");
        loggingNode.put("scopeDefinitionId", execution.getProcessDefinitionId());
        loggingNode.put("elementId", flowNode.getId());
        BpmnLoggingSessionUtil.putIfNotNull("elementName", flowNode.getName(), loggingNode);
        loggingNode.put("elementType", flowNode.getClass().getSimpleName());
        BpmnLoggingSessionUtil.putIfNotNull("elementSubType", BpmnLoggingSessionUtil.getActivitySubType((FlowElement)flowNode), loggingNode);
        loggingNode.put("activityBehavior", activityBehavior.getClass().getSimpleName());
        BpmnLoggingSessionUtil.fillScopeDefinitionInfo(execution.getProcessDefinitionId(), loggingNode);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode);
    }

    public static void addAsyncActivityLoggingData(String message, String type, JobEntity jobEntity, FlowElement flowElement, ExecutionEntity execution) {
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)execution.getProcessInstanceId(), (String)execution.getId(), (String)"bpmn");
        loggingNode.put("scopeDefinitionId", execution.getProcessDefinitionId());
        loggingNode.put("elementId", flowElement.getId());
        BpmnLoggingSessionUtil.putIfNotNull("elementName", flowElement.getName(), loggingNode);
        loggingNode.put("elementType", flowElement.getClass().getSimpleName());
        BpmnLoggingSessionUtil.putIfNotNull("elementSubType", BpmnLoggingSessionUtil.getActivitySubType(flowElement), loggingNode);
        loggingNode.put("jobId", jobEntity.getId());
        BpmnLoggingSessionUtil.fillScopeDefinitionInfo(execution.getProcessDefinitionId(), loggingNode);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode);
    }

    public static void addSequenceFlowLoggingData(String type, ExecutionEntity execution) {
        String message = null;
        FlowElement flowElement = execution.getCurrentFlowElement();
        SequenceFlow sequenceFlow = null;
        if (flowElement != null && flowElement instanceof SequenceFlow) {
            sequenceFlow = (SequenceFlow)flowElement;
            String sequenceFlowId = "";
            if (sequenceFlow.getId() != null) {
                sequenceFlowId = sequenceFlow.getId() + ", ";
            }
            message = "Sequence flow will be taken for " + sequenceFlowId + sequenceFlow.getSourceRef() + " --> " + sequenceFlow.getTargetRef();
        } else {
            message = "Sequence flow will be taken";
        }
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)execution.getProcessInstanceId(), (String)execution.getId(), (String)"bpmn");
        loggingNode.put("scopeDefinitionId", execution.getProcessDefinitionId());
        if (sequenceFlow != null) {
            BpmnLoggingSessionUtil.putIfNotNull("elementId", sequenceFlow.getId(), loggingNode);
            BpmnLoggingSessionUtil.putIfNotNull("elementName", sequenceFlow.getName(), loggingNode);
            loggingNode.put("elementType", sequenceFlow.getClass().getSimpleName());
            BpmnLoggingSessionUtil.putIfNotNull("sourceRef", sequenceFlow.getSourceRef(), loggingNode);
            BpmnLoggingSessionUtil.putIfNotNull("targetRef", sequenceFlow.getTargetRef(), loggingNode);
        }
        BpmnLoggingSessionUtil.fillScopeDefinitionInfo(execution.getProcessDefinitionId(), loggingNode);
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode);
    }

    public static ObjectNode fillBasicTaskLoggingData(String message, TaskEntity task, DelegateExecution execution) {
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)task.getProcessInstanceId(), (String)task.getExecutionId(), (String)"bpmn");
        loggingNode.put("scopeDefinitionId", execution.getProcessDefinitionId());
        loggingNode.put("taskId", task.getId());
        BpmnLoggingSessionUtil.putIfNotNull("taskName", task.getName(), loggingNode);
        BpmnLoggingSessionUtil.fillScopeDefinitionInfo(execution.getProcessDefinitionId(), loggingNode);
        BpmnLoggingSessionUtil.fillFlowElementInfo(loggingNode, execution);
        return loggingNode;
    }

    public static void addErrorLoggingData(String type, String message, Throwable t, DelegateExecution execution) {
        FlowElement flowElement = execution.getCurrentFlowElement();
        String activityId = null;
        String activityName = null;
        String activityType = null;
        String activitySubType = null;
        if (flowElement != null) {
            activityId = flowElement.getId();
            activityName = flowElement.getName();
            activityType = flowElement.getClass().getSimpleName();
            activitySubType = BpmnLoggingSessionUtil.getActivitySubType(flowElement);
        }
        ObjectNode loggingNode = LoggingSessionUtil.fillLoggingData((String)message, (String)execution.getProcessInstanceId(), (String)execution.getId(), (String)"bpmn", (String)execution.getProcessDefinitionId(), (String)activityId, (String)activityName, (String)activityType, (String)activitySubType);
        BpmnLoggingSessionUtil.fillScopeDefinitionInfo(execution.getProcessDefinitionId(), loggingNode);
        LoggingSessionUtil.addErrorLoggingData((String)type, (ObjectNode)loggingNode, (Throwable)t);
    }

    public static void fillLoggingData(ObjectNode loggingNode, ExecutionEntity executionEntity) {
        loggingNode.put("scopeDefinitionId", executionEntity.getProcessDefinitionId());
        BpmnLoggingSessionUtil.fillScopeDefinitionInfo(executionEntity.getProcessDefinitionId(), loggingNode);
        FlowElement flowElement = executionEntity.getCurrentFlowElement();
        if (flowElement == null) {
            flowElement = executionEntity.getOriginatingCurrentFlowElement();
        }
        if (flowElement != null) {
            loggingNode.put("elementId", flowElement.getId());
            BpmnLoggingSessionUtil.putIfNotNull("elementName", flowElement.getName(), loggingNode);
            loggingNode.put("elementType", flowElement.getClass().getSimpleName());
        }
    }

    public static void addTaskIdentityLinkData(String type, String message, boolean isUser, List<IdentityLinkEntity> identityLinkEntities, TaskEntity task, DelegateExecution execution) {
        ObjectNode loggingNode = BpmnLoggingSessionUtil.fillBasicTaskLoggingData(message, task, execution);
        ArrayNode identityLinkArray = null;
        identityLinkArray = isUser ? loggingNode.putArray("taskUserIdentityLinks") : loggingNode.putArray("taskGroupIdentityLinks");
        for (IdentityLinkEntity identityLink : identityLinkEntities) {
            ObjectNode identityLinkNode = identityLinkArray.addObject();
            identityLinkNode.put("id", identityLink.getId());
            identityLinkNode.put("type", identityLink.getType());
            if (isUser) {
                identityLinkNode.put("userId", identityLink.getUserId());
                continue;
            }
            identityLinkNode.put("groupId", identityLink.getGroupId());
        }
        LoggingSessionUtil.addLoggingData((String)type, (ObjectNode)loggingNode);
    }

    public static String getBoundaryCreateEventType(BoundaryEvent boundaryEvent) {
        List eventDefinitions = boundaryEvent.getEventDefinitions();
        if (eventDefinitions != null && !eventDefinitions.isEmpty()) {
            EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
            if (eventDefinition instanceof TimerEventDefinition) {
                return "boundaryTimerEventCreate";
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                return "boundaryMessageEventCreate";
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                return "boundarySignalEventCreate";
            }
            if (eventDefinition instanceof CancelEventDefinition) {
                return "boundaryCancelEventCreate";
            }
            if (eventDefinition instanceof CompensateEventDefinition) {
                return "boundaryCompensateEventCreate";
            }
            if (eventDefinition instanceof ConditionalEventDefinition) {
                return "boundaryConditionalEventCreate";
            }
            if (eventDefinition instanceof EscalationEventDefinition) {
                return "boundaryEscalationEventCreate";
            }
        }
        return "boundaryEventCreate";
    }

    public static String getBoundaryEventType(BoundaryEvent boundaryEvent) {
        List eventDefinitions = boundaryEvent.getEventDefinitions();
        if (eventDefinitions != null && !eventDefinitions.isEmpty()) {
            EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
            return eventDefinition.getClass().getSimpleName();
        }
        return "unknown";
    }

    protected static String getActivitySubType(FlowElement flowElement) {
        String activitySubType = null;
        if (flowElement instanceof Event) {
            Event event = (Event)flowElement;
            List eventDefinitions = event.getEventDefinitions();
            if (eventDefinitions != null && !eventDefinitions.isEmpty()) {
                EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
                activitySubType = eventDefinition.getClass().getSimpleName();
            }
        } else if (flowElement instanceof ServiceTask) {
            ServiceTask serviceTask = (ServiceTask)flowElement;
            if (serviceTask.getBehavior() != null && serviceTask.getBehavior() instanceof ClassDelegate) {
                ClassDelegate classDelegate = (ClassDelegate)serviceTask.getBehavior();
                activitySubType = classDelegate.getClassName();
            } else if (serviceTask.getBehavior() != null && serviceTask.getBehavior() instanceof ServiceTaskExpressionActivityBehavior) {
                activitySubType = serviceTask.getImplementation();
            } else if (serviceTask.getBehavior() != null && serviceTask.getBehavior() instanceof ServiceTaskDelegateExpressionActivityBehavior) {
                activitySubType = serviceTask.getImplementation();
            }
        }
        return activitySubType;
    }

    protected static void fillScopeDefinitionInfo(String processDefinitionId, ObjectNode loggingNode) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
        loggingNode.put("scopeDefinitionKey", processDefinition.getKey());
        loggingNode.put("scopeDefinitionName", processDefinition.getName());
    }

    protected static void fillFlowElementInfo(ObjectNode loggingNode, DelegateExecution execution) {
        FlowElement flowElement = execution.getCurrentFlowElement();
        if (flowElement != null) {
            loggingNode.put("elementId", flowElement.getId());
            BpmnLoggingSessionUtil.putIfNotNull("elementName", flowElement.getName(), loggingNode);
            loggingNode.put("elementType", flowElement.getClass().getSimpleName());
        }
    }

    protected static void putIfNotNull(String name, String value, ObjectNode loggingNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            loggingNode.put(name, value);
        }
    }

    protected static void putIfNotNull(String name, Integer value, ObjectNode loggingNode) {
        if (value != null) {
            loggingNode.put(name, value);
        }
    }

    protected static void putIfNotNull(String name, Date value, ObjectNode loggingNode) {
        if (value != null) {
            loggingNode.put(name, LoggingSessionUtil.formatDate((Date)value));
        }
    }
}

