/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.util.Arrays;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.migration.baseline.BaselineMigrationConfigurationExtension;

public class MigrationConfigPrinter {
    public static void print(Log log, Configuration configuration) {
        Location[] locations = configuration.getLocations();
        String locationsValue = String.join((CharSequence)", ", Arrays.stream(locations).map(Location::toString).toList());
        Location[] callbackLocations = configuration.getCallbackLocations();
        String callbackLocationsValue = String.join((CharSequence)", ", Arrays.stream(callbackLocations).map(Location::toString).toList());
        String workingDirectory = configuration.getWorkingDirectory();
        String workingDirectoryValue = workingDirectory != null && !workingDirectory.isEmpty() ? workingDirectory : System.getProperty("user.dir");
        String repeatablePrefixValue = configuration.getRepeatableSqlMigrationPrefix();
        String sqlPrefixValue = configuration.getSqlMigrationPrefix();
        BaselineMigrationConfigurationExtension baselineExt = (BaselineMigrationConfigurationExtension)configuration.getPluginRegister().getExact(BaselineMigrationConfigurationExtension.class);
        String baselinePrefixValue = baselineExt.getBaselineMigrationPrefix();
        String sqlSeparatorValue = configuration.getSqlMigrationSeparator();
        CharSequence[] sqlSuffixes = configuration.getSqlMigrationSuffixes();
        String sqlSuffixesValue = String.join((CharSequence)", ", sqlSuffixes);
        String[][] rows = new String[][]{{"locations", locationsValue}, {"callbackLocations", callbackLocationsValue}, {"workingDirectory", workingDirectoryValue}, {"repeatableSqlMigrationPrefix", repeatablePrefixValue}, {"sqlMigrationPrefix", sqlPrefixValue}, {"baselineMigrationPrefix", baselinePrefixValue}, {"sqlMigrationSeparator", sqlSeparatorValue}, {"sqlMigrationSuffixes", sqlSuffixesValue}};
        log.info("\n" + MigrationConfigPrinter.buildTable(rows));
    }

    private static String buildTable(String[][] rows) {
        int[] colWidths = new int[]{"Setting".length(), "Current value".length()};
        for (String[] row : rows) {
            if (row[0].length() > colWidths[0]) {
                colWidths[0] = row[0].length();
            }
            if (row[1].length() <= colWidths[1]) continue;
            colWidths[1] = row[1].length();
        }
        colWidths[0] = colWidths[0] + 2;
        colWidths[1] = colWidths[1] + 2;
        StringBuilder table = new StringBuilder();
        table.append(String.format("| %s | %s |\n", MigrationConfigPrinter.pad("Setting", colWidths[0]), MigrationConfigPrinter.pad("Value", colWidths[1])));
        table.append(String.format("|%s|%s|\n", MigrationConfigPrinter.makeLine(colWidths[0] + 2), MigrationConfigPrinter.makeLine(colWidths[1] + 2)));
        for (String[] row : rows) {
            table.append(String.format("| %s | %s |\n", MigrationConfigPrinter.pad(row[0], colWidths[0]), MigrationConfigPrinter.pad(row[1], colWidths[1])));
        }
        return table.toString();
    }

    private static String pad(String s, int len) {
        if (s.length() >= len) {
            return s;
        }
        return String.format("%-" + len + "s", s);
    }

    private static String makeLine(int count) {
        return "-".repeat(Math.max(0, count));
    }
}

