/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.sqlite.SQLiteDatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;

public class ExperimentalModeUtils {
    public static boolean isExperimentalModeActivated() {
        return System.getenv("FLYWAY_EXPERIMENTAL") != null && System.getenv("FLYWAY_EXPERIMENTAL").equalsIgnoreCase("true");
    }

    public static boolean canUseExperimentalMode(Configuration config) {
        if (config.getUrl().startsWith("mongodb")) {
            return true;
        }
        try (JdbcConnectionFactory connectionFactory = new JdbcConnectionFactory(config.getDataSource(), config, null);){
            boolean bl = connectionFactory.getDatabaseType() instanceof SQLiteDatabaseType;
            return bl;
        }
    }
}

