/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.sqlite.SQLiteDatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;

public class ExperimentalModeUtils {
    public static boolean isExperimentalModeActivated() {
        return System.getenv("FLYWAY_EXPERIMENTAL") != null && System.getenv("FLYWAY_EXPERIMENTAL").equalsIgnoreCase("true");
    }

    public static boolean canUseExperimentalMode(Configuration config, String verb) {
        Map<String, List<String>> acceptedVerbs = Map.of("mongodb", List.of("info", "validate", "migrate"), "SQLite", List.of("info", "validate", "migrate"));
        String database = ExperimentalModeUtils.getCurrentDatabase(config);
        if (database == null) {
            return false;
        }
        if (!acceptedVerbs.containsKey(database)) {
            return false;
        }
        return acceptedVerbs.get(database).contains(verb);
    }

    private static String getCurrentDatabase(Configuration config) {
        if (config.getUrl().startsWith("mongodb")) {
            return "mongodb";
        }
        try (JdbcConnectionFactory connectionFactory = new JdbcConnectionFactory(config.getDataSource(), config, null);){
            if (connectionFactory.getDatabaseType() instanceof SQLiteDatabaseType) {
                String string = "SQLite";
                return string;
            }
        }
        return null;
    }
}

