/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.RootTelemetryModel;
import org.flywaydb.core.extensibility.TelemetryPlugin;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class FlywayTelemetryManager
implements AutoCloseable {
    private final PluginRegister pluginRegister;
    private final Future<List<TelemetryPlugin>> initialized;
    private Future<? extends RootTelemetryModel> rootTelemetryModelFuture;
    private final Collection<Future<Void>> eventFutures = new ConcurrentLinkedDeque<Future<Void>>();
    private RootTelemetryModel rootTelemetryModel = new RootTelemetryModel();

    public FlywayTelemetryManager(PluginRegister pluginRegister) {
        this.pluginRegister = pluginRegister;
        this.initialized = CompletableFuture.supplyAsync(this::initialize);
    }

    public void setRootTelemetryModel(Future<? extends RootTelemetryModel> rootTelemetryModel) {
        this.rootTelemetryModelFuture = rootTelemetryModel;
        CompletableFuture.runAsync(() -> {
            try {
                this.rootTelemetryModel = (RootTelemetryModel)rootTelemetryModel.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new FlywayException(e);
            }
        });
    }

    private List<TelemetryPlugin> initialize() {
        List<TelemetryPlugin> telemetryPlugins = this.pluginRegister.getPlugins(TelemetryPlugin.class);
        for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
            telemetryPlugin.logRootDetails(this.rootTelemetryModel);
        }
        String userId = System.getenv("RG_TELEMETRY_ANONYMOUS_USER_ID");
        if (!StringUtils.hasText(userId)) {
            userId = FileUtils.readUserIdFromFileIfNoneWriteDefault();
        }
        this.rootTelemetryModel.setUserId(userId);
        String sessionId = System.getenv("RG_TELEMETRY_SESSION_ID");
        if (!StringUtils.hasText(sessionId)) {
            sessionId = UUID.randomUUID().toString();
        }
        this.rootTelemetryModel.setSessionId(sessionId);
        String operationId = System.getenv("RG_TELEMETRY_OPERATION_ID");
        if (!StringUtils.hasText(operationId)) {
            operationId = UUID.randomUUID().toString();
        }
        this.rootTelemetryModel.setOperationId(operationId);
        return telemetryPlugins;
    }

    public void logEvent(EventTelemetryModel model) {
        this.eventFutures.add(CompletableFuture.runAsync(() -> {
            try {
                List<TelemetryPlugin> telemetryPlugins = this.initialized.get();
                if (this.rootTelemetryModelFuture != null) {
                    this.rootTelemetryModelFuture.get();
                }
                for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
                    telemetryPlugin.logEventDetails(model);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new FlywayException(e);
            }
        }));
    }

    @Override
    public void close() throws FlywayException {
        CompletableFuture.runAsync(() -> {
            try {
                List<TelemetryPlugin> telemetryPlugins = this.initialized.get();
                if (this.rootTelemetryModelFuture != null) {
                    this.rootTelemetryModelFuture.get();
                }
                for (Future<Void> eventFuture : this.eventFutures) {
                    eventFuture.get();
                }
                for (TelemetryPlugin telemetryPlugin : telemetryPlugins) {
                    telemetryPlugin.close();
                }
            }
            catch (Exception e) {
                throw new FlywayException(e);
            }
        });
    }

    public RootTelemetryModel getRootTelemetryModel() {
        return this.rootTelemetryModel;
    }
}

