/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.util.Map;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;
import org.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;

public class ProvisionerConfiguration {
    public static void requireDryRunUnsetForProvision(PropertyResolverContext context) {
        if (context.getConfiguration().getDryRunOutput() != null) {
            throw new FlywayException("Provisioning " + context.getEnvironmentName() + " would alter the environment or have side effects, so is not supported with dry run enabled.", CoreErrorCode.CONFIGURATION);
        }
    }

    public static void requireDryRunUnsetForReprovision(PropertyResolverContext context) {
        if (context.getConfiguration().getDryRunOutput() != null) {
            throw new FlywayException("Reprovisioning " + context.getEnvironmentName() + " would alter the environment or have side effects, so is not supported with dry run enabled.", CoreErrorCode.CONFIGURATION);
        }
    }

    public static ClassicConfiguration createConfigurationWithEnvironment(Configuration configuration, String environmentName, EnvironmentModel environmentModel) {
        ConfigurationModel newConfigurationModel = ConfigurationModel.clone(configuration.getModernConfig());
        ClassicConfiguration newConfiguration = new ClassicConfiguration(newConfigurationModel);
        newConfiguration.setAllEnvironments(Map.of(environmentName, environmentModel));
        newConfiguration.setEnvironment(environmentName);
        newConfiguration.setProvisionMode(ProvisionerMode.Skip);
        newConfiguration.setCallbacks(configuration.getCallbacks());
        newConfiguration.setPluginRegister(configuration.getPluginRegister().getCopy());
        newConfiguration.setWorkingDirectory(configuration.getWorkingDirectory());
        return newConfiguration;
    }

    public static ClassicConfiguration createConfigurationWithEnvironment(PropertyResolverContext context, ResolvedEnvironment resolvedEnvironment) {
        return ProvisionerConfiguration.createConfigurationWithEnvironment(context.getConfiguration(), context.getEnvironmentName(), resolvedEnvironment.toEnvironmentModel());
    }

    public static ClassicConfiguration createConfigurationWithEnvironment(PropertyResolverContext context, EnvironmentModel environmentModel) {
        return ProvisionerConfiguration.createConfigurationWithEnvironment(context.getConfiguration(), context.getEnvironmentName(), environmentModel);
    }
}

