/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import java.util.Optional;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.ExperimentalDatabasePluginResolverImpl;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.internal.configuration.ConfigurationValidator;

public class ExperimentalModeUtils {
    private static final Log LOG = LogFactory.getLog(ExperimentalModeUtils.class);

    public static boolean canUseExperimentalMode(Configuration config, String verb) {
        if (ExperimentalModeUtils.isNativeConnectorsTurnedOff()) {
            return false;
        }
        if (ExperimentalModeUtils.useLegacyAsDryRunSet(config)) {
            if (ExperimentalModeUtils.isNativeConnectorsTurnedOn()) {
                LOG.warn("Dry run is not supported in Native Connectors mode, falling back to legacy databases");
            }
            return false;
        }
        if (config.getUrl() == null) {
            return false;
        }
        new ConfigurationValidator().validate(config);
        Optional<ExperimentalDatabase> database = ExperimentalModeUtils.resolveExperimentalDatabasePlugin(config);
        return database.map(experimentalDatabase -> experimentalDatabase.supportedVerbs().contains(verb) && (experimentalDatabase.isOnByDefault(config) || ExperimentalModeUtils.isNativeConnectorsTurnedOn())).orElse(false);
    }

    public static boolean canCreateDataSource(Configuration config) {
        if (ExperimentalModeUtils.useLegacyAsDryRunSet(config)) {
            return true;
        }
        if (!ExperimentalModeUtils.isNativeConnectorsTurnedOff()) {
            if (config.getUrl() == null) {
                return true;
            }
            Optional<ExperimentalDatabase> database = ExperimentalModeUtils.resolveExperimentalDatabasePlugin(config);
            return database.map(experimentalDatabase -> experimentalDatabase.canCreateJdbcDataSource() || !experimentalDatabase.isOnByDefault(config)).orElse(true);
        }
        return true;
    }

    public static void logExperimentalDataTelemetry(FlywayTelemetryManager flywayTelemetryManager, MetaData metaData) {
        if (flywayTelemetryManager != null) {
            flywayTelemetryManager.notifyExperimentalMetadataChanged(metaData);
        }
    }

    private static boolean useLegacyAsDryRunSet(Configuration config) {
        return config.getDryRunOutput() != null;
    }

    public static Optional<ExperimentalDatabase> resolveExperimentalDatabasePlugin(Configuration configuration) {
        return new ExperimentalDatabasePluginResolverImpl(configuration.getPluginRegister()).resolve(configuration.getUrl());
    }

    public static boolean isNativeConnectorsTurnedOn() {
        return System.getenv("FLYWAY_NATIVE_CONNECTORS") != null && System.getenv("FLYWAY_NATIVE_CONNECTORS").equalsIgnoreCase("true");
    }

    public static boolean isNativeConnectorsTurnedOff() {
        return System.getenv("FLYWAY_NATIVE_CONNECTORS") != null && System.getenv("FLYWAY_NATIVE_CONNECTORS").equalsIgnoreCase("false");
    }
}

