/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.configuration.models.PropertyResolver;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.MergeUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class FlywayEnvironmentModel {
    public static final String DEFAULT_REPORT_FILENAME = "report";
    private String reportFilename;
    private Boolean detectEncoding;
    private String encoding;
    private String placeholderPrefix;
    private String placeholderSuffix;
    private String placeholderSeparator;
    private String scriptPlaceholderPrefix;
    private String scriptPlaceholderSuffix;
    private String sqlMigrationPrefix;
    private Boolean executeInTransaction;
    private String repeatableSqlMigrationPrefix;
    private String sqlMigrationSeparator;
    private List<String> sqlMigrationSuffixes;
    private Boolean cleanDisabled;
    private Boolean cleanOnValidationError;
    private Boolean communityDBSupportEnabled;
    private List<String> locations;
    private List<String> jarDirs;
    private String table;
    private String tablespace;
    private String target;
    private Boolean failOnMissingTarget;
    private Boolean placeholderReplacement;
    private List<String> ignoreMigrationPatterns;
    private Boolean validateMigrationNaming;
    private Boolean validateOnMigrate;
    private String baselineVersion;
    private String baselineDescription;
    private Boolean baselineOnMigrate;
    private Boolean outOfOrder;
    private Boolean skipExecutingMigrations;
    private List<String> callbacks;
    private Boolean skipDefaultCallbacks;
    private List<String> migrationResolvers;
    private Boolean skipDefaultResolvers;
    private Boolean mixed;
    private Boolean group;
    private String installedBy;
    private Boolean createSchemas;
    private List<String> errorOverrides;
    private String dryRunOutput;
    private Boolean stream;
    private Boolean batch;
    private Boolean outputQueryResults;
    private Integer lockRetryCount;
    private String kerberosConfigFile;
    private Boolean failOnMissingLocations;
    private List<String> loggers;
    private Map<String, String> placeholders;
    private String defaultSchema;
    private Map<String, PropertyResolver> propertyResolvers;
    private Boolean reportEnabled;
    @JsonAnySetter
    private Map<String, Object> pluginConfigurations = new HashMap<String, Object>();

    public FlywayEnvironmentModel merge(FlywayEnvironmentModel otherPojo) {
        FlywayEnvironmentModel result = new FlywayEnvironmentModel();
        result.reportFilename = MergeUtils.merge(this.reportFilename, otherPojo.reportFilename);
        result.encoding = MergeUtils.merge(this.encoding, otherPojo.encoding);
        result.detectEncoding = MergeUtils.merge(this.detectEncoding, otherPojo.detectEncoding);
        result.placeholderPrefix = MergeUtils.merge(this.placeholderPrefix, otherPojo.placeholderPrefix);
        result.placeholderSuffix = MergeUtils.merge(this.placeholderSuffix, otherPojo.placeholderSuffix);
        result.placeholderSeparator = MergeUtils.merge(this.placeholderSeparator, otherPojo.placeholderSeparator);
        result.scriptPlaceholderPrefix = MergeUtils.merge(this.scriptPlaceholderPrefix, otherPojo.scriptPlaceholderPrefix);
        result.scriptPlaceholderSuffix = MergeUtils.merge(this.scriptPlaceholderSuffix, otherPojo.scriptPlaceholderSuffix);
        result.sqlMigrationPrefix = MergeUtils.merge(this.sqlMigrationPrefix, otherPojo.sqlMigrationPrefix);
        result.executeInTransaction = MergeUtils.merge(this.executeInTransaction, otherPojo.executeInTransaction);
        result.repeatableSqlMigrationPrefix = MergeUtils.merge(this.repeatableSqlMigrationPrefix, otherPojo.repeatableSqlMigrationPrefix);
        result.sqlMigrationSeparator = MergeUtils.merge(this.sqlMigrationSeparator, otherPojo.sqlMigrationSeparator);
        result.sqlMigrationSuffixes = MergeUtils.merge(this.sqlMigrationSuffixes, otherPojo.sqlMigrationSuffixes);
        result.cleanDisabled = MergeUtils.merge(this.cleanDisabled, otherPojo.cleanDisabled);
        result.cleanOnValidationError = MergeUtils.merge(this.cleanOnValidationError, otherPojo.cleanOnValidationError);
        result.communityDBSupportEnabled = MergeUtils.merge(this.communityDBSupportEnabled, otherPojo.communityDBSupportEnabled);
        result.locations = MergeUtils.merge(this.locations, otherPojo.locations);
        result.jarDirs = MergeUtils.merge(this.jarDirs, otherPojo.jarDirs);
        result.table = MergeUtils.merge(this.table, otherPojo.table);
        result.tablespace = MergeUtils.merge(this.tablespace, otherPojo.tablespace);
        result.target = MergeUtils.merge(this.target, otherPojo.target);
        result.failOnMissingTarget = MergeUtils.merge(this.failOnMissingTarget, otherPojo.failOnMissingTarget);
        result.placeholderReplacement = MergeUtils.merge(this.placeholderReplacement, otherPojo.placeholderReplacement);
        result.ignoreMigrationPatterns = MergeUtils.merge(this.ignoreMigrationPatterns, otherPojo.ignoreMigrationPatterns);
        result.validateMigrationNaming = MergeUtils.merge(this.validateMigrationNaming, otherPojo.validateMigrationNaming);
        result.validateOnMigrate = MergeUtils.merge(this.validateOnMigrate, otherPojo.validateOnMigrate);
        result.baselineVersion = MergeUtils.merge(this.baselineVersion, otherPojo.baselineVersion);
        result.baselineDescription = MergeUtils.merge(this.baselineDescription, otherPojo.baselineDescription);
        result.baselineOnMigrate = MergeUtils.merge(this.baselineOnMigrate, otherPojo.baselineOnMigrate);
        result.outOfOrder = MergeUtils.merge(this.outOfOrder, otherPojo.outOfOrder);
        result.skipExecutingMigrations = MergeUtils.merge(this.skipExecutingMigrations, otherPojo.skipExecutingMigrations);
        result.callbacks = MergeUtils.merge(this.callbacks, otherPojo.callbacks);
        result.skipDefaultCallbacks = MergeUtils.merge(this.skipDefaultCallbacks, otherPojo.skipDefaultCallbacks);
        result.migrationResolvers = MergeUtils.merge(this.migrationResolvers, otherPojo.migrationResolvers);
        result.skipDefaultResolvers = MergeUtils.merge(this.skipDefaultResolvers, otherPojo.skipDefaultResolvers);
        result.mixed = MergeUtils.merge(this.mixed, otherPojo.mixed);
        result.group = MergeUtils.merge(this.group, otherPojo.group);
        result.installedBy = MergeUtils.merge(this.installedBy, otherPojo.installedBy);
        result.createSchemas = MergeUtils.merge(this.createSchemas, otherPojo.createSchemas);
        result.errorOverrides = MergeUtils.merge(this.errorOverrides, otherPojo.errorOverrides);
        result.dryRunOutput = MergeUtils.merge(this.dryRunOutput, otherPojo.dryRunOutput);
        result.stream = MergeUtils.merge(this.stream, otherPojo.stream);
        result.batch = MergeUtils.merge(this.batch, otherPojo.batch);
        result.outputQueryResults = MergeUtils.merge(this.outputQueryResults, otherPojo.outputQueryResults);
        result.lockRetryCount = MergeUtils.merge(this.lockRetryCount, otherPojo.lockRetryCount);
        result.kerberosConfigFile = MergeUtils.merge(this.kerberosConfigFile, otherPojo.kerberosConfigFile);
        result.failOnMissingLocations = MergeUtils.merge(this.failOnMissingLocations, otherPojo.failOnMissingLocations);
        result.loggers = MergeUtils.merge(this.loggers, otherPojo.loggers);
        result.defaultSchema = MergeUtils.merge(this.defaultSchema, otherPojo.defaultSchema);
        result.placeholders = MergeUtils.merge(this.placeholders, otherPojo.placeholders, (a, b) -> b != null ? b : a);
        result.reportEnabled = MergeUtils.merge(this.reportEnabled, otherPojo.reportEnabled);
        result.propertyResolvers = MergeUtils.merge(this.propertyResolvers, otherPojo.propertyResolvers, (a, b) -> b != null ? b : a);
        result.pluginConfigurations = MergeUtils.merge(this.pluginConfigurations, otherPojo.pluginConfigurations, MergeUtils::mergeObjects);
        return result;
    }

    public void setReportFilename(String reportFilename) {
        if (StringUtils.hasText(reportFilename)) {
            this.reportFilename = reportFilename;
        }
    }

    public String toString() {
        return ClassUtils.getGettableFieldValues(this, "").toString();
    }

    public String getReportFilename() {
        return this.reportFilename;
    }

    public Boolean getDetectEncoding() {
        return this.detectEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public String getPlaceholderSeparator() {
        return this.placeholderSeparator;
    }

    public String getScriptPlaceholderPrefix() {
        return this.scriptPlaceholderPrefix;
    }

    public String getScriptPlaceholderSuffix() {
        return this.scriptPlaceholderSuffix;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public Boolean getExecuteInTransaction() {
        return this.executeInTransaction;
    }

    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    public List<String> getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    public Boolean getCleanDisabled() {
        return this.cleanDisabled;
    }

    public Boolean getCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    public Boolean getCommunityDBSupportEnabled() {
        return this.communityDBSupportEnabled;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public List<String> getJarDirs() {
        return this.jarDirs;
    }

    public String getTable() {
        return this.table;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public String getTarget() {
        return this.target;
    }

    public Boolean getFailOnMissingTarget() {
        return this.failOnMissingTarget;
    }

    public Boolean getPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    public List<String> getIgnoreMigrationPatterns() {
        return this.ignoreMigrationPatterns;
    }

    public Boolean getValidateMigrationNaming() {
        return this.validateMigrationNaming;
    }

    public Boolean getValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public String getBaselineVersion() {
        return this.baselineVersion;
    }

    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    public Boolean getBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    public Boolean getOutOfOrder() {
        return this.outOfOrder;
    }

    public Boolean getSkipExecutingMigrations() {
        return this.skipExecutingMigrations;
    }

    public List<String> getCallbacks() {
        return this.callbacks;
    }

    public Boolean getSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    public List<String> getMigrationResolvers() {
        return this.migrationResolvers;
    }

    public Boolean getSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    public Boolean getMixed() {
        return this.mixed;
    }

    public Boolean getGroup() {
        return this.group;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    public Boolean getCreateSchemas() {
        return this.createSchemas;
    }

    public List<String> getErrorOverrides() {
        return this.errorOverrides;
    }

    public String getDryRunOutput() {
        return this.dryRunOutput;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Boolean getBatch() {
        return this.batch;
    }

    public Boolean getOutputQueryResults() {
        return this.outputQueryResults;
    }

    public Integer getLockRetryCount() {
        return this.lockRetryCount;
    }

    public String getKerberosConfigFile() {
        return this.kerberosConfigFile;
    }

    public Boolean getFailOnMissingLocations() {
        return this.failOnMissingLocations;
    }

    public List<String> getLoggers() {
        return this.loggers;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public Map<String, PropertyResolver> getPropertyResolvers() {
        return this.propertyResolvers;
    }

    public Boolean getReportEnabled() {
        return this.reportEnabled;
    }

    public void setDetectEncoding(Boolean detectEncoding) {
        this.detectEncoding = detectEncoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setPlaceholderSeparator(String placeholderSeparator) {
        this.placeholderSeparator = placeholderSeparator;
    }

    public void setScriptPlaceholderPrefix(String scriptPlaceholderPrefix) {
        this.scriptPlaceholderPrefix = scriptPlaceholderPrefix;
    }

    public void setScriptPlaceholderSuffix(String scriptPlaceholderSuffix) {
        this.scriptPlaceholderSuffix = scriptPlaceholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setExecuteInTransaction(Boolean executeInTransaction) {
        this.executeInTransaction = executeInTransaction;
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.repeatableSqlMigrationPrefix = repeatableSqlMigrationPrefix;
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        this.sqlMigrationSeparator = sqlMigrationSeparator;
    }

    public void setSqlMigrationSuffixes(List<String> sqlMigrationSuffixes) {
        this.sqlMigrationSuffixes = sqlMigrationSuffixes;
    }

    public void setCleanDisabled(Boolean cleanDisabled) {
        this.cleanDisabled = cleanDisabled;
    }

    public void setCleanOnValidationError(Boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public void setCommunityDBSupportEnabled(Boolean communityDBSupportEnabled) {
        this.communityDBSupportEnabled = communityDBSupportEnabled;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public void setJarDirs(List<String> jarDirs) {
        this.jarDirs = jarDirs;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setFailOnMissingTarget(Boolean failOnMissingTarget) {
        this.failOnMissingTarget = failOnMissingTarget;
    }

    public void setPlaceholderReplacement(Boolean placeholderReplacement) {
        this.placeholderReplacement = placeholderReplacement;
    }

    public void setIgnoreMigrationPatterns(List<String> ignoreMigrationPatterns) {
        this.ignoreMigrationPatterns = ignoreMigrationPatterns;
    }

    public void setValidateMigrationNaming(Boolean validateMigrationNaming) {
        this.validateMigrationNaming = validateMigrationNaming;
    }

    public void setValidateOnMigrate(Boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public void setBaselineVersion(String baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public void setBaselineDescription(String baselineDescription) {
        this.baselineDescription = baselineDescription;
    }

    public void setBaselineOnMigrate(Boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public void setOutOfOrder(Boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public void setSkipExecutingMigrations(Boolean skipExecutingMigrations) {
        this.skipExecutingMigrations = skipExecutingMigrations;
    }

    public void setCallbacks(List<String> callbacks) {
        this.callbacks = callbacks;
    }

    public void setSkipDefaultCallbacks(Boolean skipDefaultCallbacks) {
        this.skipDefaultCallbacks = skipDefaultCallbacks;
    }

    public void setMigrationResolvers(List<String> migrationResolvers) {
        this.migrationResolvers = migrationResolvers;
    }

    public void setSkipDefaultResolvers(Boolean skipDefaultResolvers) {
        this.skipDefaultResolvers = skipDefaultResolvers;
    }

    public void setMixed(Boolean mixed) {
        this.mixed = mixed;
    }

    public void setGroup(Boolean group) {
        this.group = group;
    }

    public void setInstalledBy(String installedBy) {
        this.installedBy = installedBy;
    }

    public void setCreateSchemas(Boolean createSchemas) {
        this.createSchemas = createSchemas;
    }

    public void setErrorOverrides(List<String> errorOverrides) {
        this.errorOverrides = errorOverrides;
    }

    public void setDryRunOutput(String dryRunOutput) {
        this.dryRunOutput = dryRunOutput;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setBatch(Boolean batch) {
        this.batch = batch;
    }

    public void setOutputQueryResults(Boolean outputQueryResults) {
        this.outputQueryResults = outputQueryResults;
    }

    public void setLockRetryCount(Integer lockRetryCount) {
        this.lockRetryCount = lockRetryCount;
    }

    public void setKerberosConfigFile(String kerberosConfigFile) {
        this.kerberosConfigFile = kerberosConfigFile;
    }

    public void setFailOnMissingLocations(Boolean failOnMissingLocations) {
        this.failOnMissingLocations = failOnMissingLocations;
    }

    public void setLoggers(List<String> loggers) {
        this.loggers = loggers;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void setPropertyResolvers(Map<String, PropertyResolver> propertyResolvers) {
        this.propertyResolvers = propertyResolvers;
    }

    public void setReportEnabled(Boolean reportEnabled) {
        this.reportEnabled = reportEnabled;
    }

    public void setPluginConfigurations(Map<String, Object> pluginConfigurations) {
        this.pluginConfigurations = pluginConfigurations;
    }

    @ClassUtils.DoNotMapForLogging
    public Map<String, Object> getPluginConfigurations() {
        return this.pluginConfigurations;
    }
}

