/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.sybase.ase;

import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.dbsupport.sybase.ase.SybaseASEDbSupport;
import org.flywaydb.core.internal.dbsupport.sybase.ase.SybaseASETable;

public class SybaseASESchema
extends Schema<SybaseASEDbSupport> {
    public SybaseASESchema(JdbcTemplate jdbcTemplate, SybaseASEDbSupport dbSupport, String name) {
        super(jdbcTemplate, dbSupport, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return true;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        return this.jdbcTemplate.queryForInt("select count(*) from sysobjects ob where (ob.type='U' or ob.type = 'V' or ob.type = 'P' or ob.type = 'TR') and ob.name != 'sysquerymetrics'", new String[0]) == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
    }

    @Override
    protected void doDrop() throws SQLException {
    }

    @Override
    protected void doClean() throws SQLException {
        this.dropObjects("U");
        this.dropObjects("V");
        this.dropObjects("P");
        this.dropObjects("TR");
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.retrieveAllTableNames();
        Table[] result = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            String tableName = tableNames.get(i);
            result[i] = new SybaseASETable(this.jdbcTemplate, this.dbSupport, this, tableName);
        }
        return result;
    }

    @Override
    public Table getTable(String tableName) {
        return new SybaseASETable(this.jdbcTemplate, this.dbSupport, this, tableName);
    }

    private List<String> retrieveAllTableNames() throws SQLException {
        List<String> objNames = this.jdbcTemplate.queryForStringList("select ob.name from sysobjects ob where ob.type=? order by ob.name", "U");
        return objNames;
    }

    private void dropObjects(String sybaseObjType) throws SQLException {
        List<String> objNames = this.jdbcTemplate.queryForStringList("select ob.name from sysobjects ob where ob.type=? order by ob.name", sybaseObjType);
        for (String name : objNames) {
            String sql = "";
            if ("U".equals(sybaseObjType)) {
                sql = "drop table ";
            } else if ("V".equals(sybaseObjType)) {
                sql = "drop view ";
            } else if ("P".equals(sybaseObjType)) {
                sql = "drop procedure ";
            } else if ("TR".equals(sybaseObjType)) {
                sql = "drop trigger ";
            } else {
                throw new IllegalArgumentException("Unknown database object type " + sybaseObjType);
            }
            this.jdbcTemplate.execute(sql + name, new Object[0]);
        }
    }
}

