/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class ClassUtils {
    private static final Log LOG = LogFactory.getLog(ClassUtils.class);

    private ClassUtils() {
    }

    public static synchronized <T> T instantiate(String className, ClassLoader classLoader) throws Exception {
        return (T)Class.forName(className, true, classLoader).newInstance();
    }

    public static <T> List<T> instantiateAll(String[] classes, ClassLoader classLoader) {
        ArrayList<T> clazzes = new ArrayList<T>();
        for (String clazz : classes) {
            if (!StringUtils.hasLength(clazz)) continue;
            try {
                clazzes.add(ClassUtils.instantiate(clazz, classLoader));
            }
            catch (Exception e) {
                throw new FlywayException("Unable to instantiate class: " + clazz, e);
            }
        }
        return clazzes;
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static String getShortName(Class<?> aClass) {
        String name = aClass.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static String getLocationOnDisk(Class<?> aClass) {
        try {
            ProtectionDomain protectionDomain = aClass.getProtectionDomain();
            if (protectionDomain == null) {
                return null;
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return null;
            }
            String url = codeSource.getLocation().getPath();
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static void addJarOrDirectoryToClasspath(String name) throws IOException {
        LOG.debug("Adding location to classpath: " + name);
        try {
            URL url = new File(name).toURI().toURL();
            URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, url);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to load " + name, e);
        }
    }
}

