/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.RowMapper;
import org.flywaydb.core.internal.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;

class JdbcTableSchemaHistory
extends SchemaHistory {
    private static final Log LOG = LogFactory.getLog(JdbcTableSchemaHistory.class);
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final SqlScriptFactory sqlScriptFactory;
    private final Database database;
    private final Connection<?> connection;
    private final JdbcTemplate jdbcTemplate;
    private final LinkedList<AppliedMigration> cache = new LinkedList();

    JdbcTableSchemaHistory(SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Database database, Table table) {
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.sqlScriptFactory = sqlScriptFactory;
        this.table = table;
        this.database = database;
        this.connection = database.getMainConnection();
        this.jdbcTemplate = this.connection.getJdbcTemplate();
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public boolean exists() {
        this.connection.restoreOriginalState();
        return this.table.exists();
    }

    @Override
    public void create(final boolean baseline) {
        this.connection.lock(this.table, new Callable<Object>(){

            @Override
            public Object call() {
                int retries = 0;
                while (!JdbcTableSchemaHistory.this.exists()) {
                    if (retries == 0) {
                        LOG.info("Creating Schema History table " + JdbcTableSchemaHistory.this.table + (baseline ? " with baseline" : "") + " ...");
                    }
                    try {
                        new TransactionTemplate(JdbcTableSchemaHistory.this.connection.getJdbcConnection(), true).execute(new Callable<Object>(){

                            @Override
                            public Object call() {
                                JdbcTableSchemaHistory.this.sqlScriptExecutorFactory.createSqlScriptExecutor(JdbcTableSchemaHistory.this.connection.getJdbcConnection()).execute(JdbcTableSchemaHistory.this.database.getCreateScript(JdbcTableSchemaHistory.this.sqlScriptFactory, JdbcTableSchemaHistory.this.table, baseline));
                                LOG.debug("Created Schema History table " + JdbcTableSchemaHistory.this.table + (baseline ? " with baseline" : ""));
                                return null;
                            }
                        });
                    }
                    catch (FlywayException e) {
                        if (++retries >= 10) {
                            throw e;
                        }
                        try {
                            LOG.debug("Schema History table creation failed. Retrying in 1 sec ...");
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                return null;
            }
        });
    }

    @Override
    public <T> T lock(Callable<T> callable) {
        this.connection.restoreOriginalState();
        return this.connection.lock(this.table, callable);
    }

    @Override
    protected void doAddAppliedMigration(int installedRank, MigrationVersion version, String description, MigrationType type, String script, Integer checksum, int executionTime, boolean success) {
        this.connection.restoreOriginalState();
        if (!this.database.supportsDdlTransactions()) {
            this.table.lock();
        }
        try {
            String versionStr = version == null ? null : version.toString();
            this.jdbcTemplate.update(this.database.getInsertStatement(this.table), installedRank, versionStr, description, type.name(), script, checksum, this.database.getInstalledBy(), executionTime, success);
            LOG.debug("Schema History table " + this.table + " successfully updated to reflect changes");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to insert row for version '" + version + "' in Schema History table " + this.table, e);
        }
    }

    @Override
    public List<AppliedMigration> allAppliedMigrations() {
        if (!this.exists()) {
            return new ArrayList<AppliedMigration>();
        }
        this.refreshCache();
        return this.cache;
    }

    private void refreshCache() {
        int maxCachedInstalledRank = this.cache.isEmpty() ? -1 : this.cache.getLast().getInstalledRank();
        String query = this.database.getSelectStatement(this.table);
        try {
            this.cache.addAll(this.jdbcTemplate.query(query, new RowMapper<AppliedMigration>(){

                @Override
                public AppliedMigration mapRow(ResultSet rs) throws SQLException {
                    String type;
                    Integer checksum = rs.getInt("checksum");
                    if (rs.wasNull()) {
                        checksum = null;
                    }
                    if ("SPRING_JDBC".equals(type = rs.getString("type"))) {
                        type = "JDBC";
                    }
                    if ("UNDO_SPRING_JDBC".equals(type)) {
                        type = "UNDO_JDBC";
                    }
                    return new AppliedMigration(rs.getInt("installed_rank"), rs.getString("version") != null ? MigrationVersion.fromVersion(rs.getString("version")) : null, rs.getString("description"), MigrationType.valueOf(type), rs.getString("script"), checksum, rs.getTimestamp("installed_on"), rs.getString("installed_by"), rs.getInt("execution_time"), rs.getBoolean("success"));
                }
            }, maxCachedInstalledRank));
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error while retrieving the list of applied migrations from Schema History table " + this.table, e);
        }
    }

    @Override
    public void removeFailedMigrations() {
        if (!this.exists()) {
            LOG.info("Repair of failed migration in Schema History table " + this.table + " not necessary as table doesn't exist.");
            return;
        }
        boolean failed = false;
        List<AppliedMigration> appliedMigrations = this.allAppliedMigrations();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            if (appliedMigration.isSuccess()) continue;
            failed = true;
        }
        if (!failed) {
            LOG.info("Repair of failed migration in Schema History table " + this.table + " not necessary. No failed migration detected.");
            return;
        }
        try {
            this.clearCache();
            this.jdbcTemplate.execute("DELETE FROM " + this.table + " WHERE " + this.database.quote("success") + " = " + this.database.getBooleanFalse(), new Object[0]);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to repair Schema History table " + this.table, e);
        }
    }

    @Override
    public void update(AppliedMigration appliedMigration, ResolvedMigration resolvedMigration) {
        this.connection.restoreOriginalState();
        this.clearCache();
        MigrationVersion version = appliedMigration.getVersion();
        String description = resolvedMigration.getDescription();
        Integer checksum = resolvedMigration.getChecksum();
        MigrationType type = appliedMigration.getType().isSynthetic() ? appliedMigration.getType() : resolvedMigration.getType();
        LOG.info("Repairing Schema History table for version " + version + " (Description: " + description + ", Type: " + (Object)((Object)type) + ", Checksum: " + checksum + ")  ...");
        try {
            this.jdbcTemplate.update("UPDATE " + this.table + " SET " + this.database.quote("description") + "=? , " + this.database.quote("type") + "=? , " + this.database.quote("checksum") + "=? WHERE " + this.database.quote("version") + "=?", new Object[]{description, type, checksum, version});
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to repair Schema History table " + this.table + " for version " + version, e);
        }
    }
}

