/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementIterator;

public class ParserSqlScript
implements SqlScript {
    private static final Log LOG = LogFactory.getLog(ParserSqlScript.class);
    protected final List<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
    private int sqlStatementCount;
    private boolean nonTransactionalStatementFound;
    protected final LoadableResource resource;
    protected final Parser parser;
    private final boolean mixed;
    private boolean parsed;

    public ParserSqlScript(Parser parser, LoadableResource resource, boolean mixed) {
        this.resource = resource;
        this.parser = parser;
        this.mixed = mixed;
    }

    protected void parse() {
        try (SqlStatementIterator sqlStatementIterator = this.parser.parse(this.resource);){
            boolean transactionalStatementFound = false;
            while (sqlStatementIterator.hasNext()) {
                SqlStatement sqlStatement = (SqlStatement)sqlStatementIterator.next();
                this.sqlStatements.add(sqlStatement);
                ++this.sqlStatementCount;
                if (sqlStatement.canExecuteInTransaction()) {
                    transactionalStatementFound = true;
                } else {
                    this.nonTransactionalStatementFound = true;
                }
                if (!this.mixed && transactionalStatementFound && this.nonTransactionalStatementFound) {
                    throw new FlywayException("Detected both transactional and non-transactional statements within the same migration (even though mixed is false). Offending statement found at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatement.canExecuteInTransaction() ? "" : " [non-transactional]"));
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Found statement at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatement.canExecuteInTransaction() ? "" : " [non-transactional]"));
            }
        }
        this.parsed = true;
    }

    @Override
    public void validate() {
        if (!this.parsed) {
            this.parse();
        }
    }

    @Override
    public SqlStatementIterator getSqlStatements() {
        this.validate();
        final Iterator<SqlStatement> iterator = this.sqlStatements.iterator();
        return new SqlStatementIterator(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public SqlStatement next() {
                return (SqlStatement)iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public int getSqlStatementCount() {
        this.validate();
        return this.sqlStatementCount;
    }

    @Override
    public final LoadableResource getResource() {
        return this.resource;
    }

    @Override
    public boolean executeInTransaction() {
        this.validate();
        return !this.nonTransactionalStatementFound;
    }

    @Override
    public int compareTo(SqlScript o) {
        return this.resource.getRelativePath().compareTo(o.getResource().getRelativePath());
    }
}

