/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flywaydb.core.api.ErrorDetails;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.InfoOutput;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.MigrateOutput;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.RepairOutput;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.UndoOutput;
import org.flywaydb.core.api.output.UndoResult;
import org.flywaydb.core.api.output.ValidateOutput;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;

public class CommandResultFactory {
    public static InfoResult createInfoResult(Configuration configuration, Database database, MigrationInfo[] migrationInfos, MigrationInfo current, boolean allSchemasEmpty) {
        String flywayVersion = VersionPrinter.getVersion();
        String databaseName = CommandResultFactory.getDatabaseName(configuration, database);
        Set<MigrationVersion> undoableVersions = CommandResultFactory.getUndoableVersions(migrationInfos);
        ArrayList<InfoOutput> infoOutputs = new ArrayList<InfoOutput>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            infoOutputs.add(CommandResultFactory.createInfoOutput(undoableVersions, migrationInfo));
        }
        MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
        MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
        String schemaVersion = schemaVersionToOutput.getVersion();
        return new InfoResult(flywayVersion, databaseName, schemaVersion, String.join((CharSequence)", ", configuration.getSchemas()), infoOutputs, allSchemasEmpty);
    }

    public static MigrateResult createMigrateResult(String databaseName, Configuration configuration) {
        String flywayVersion = VersionPrinter.getVersion();
        return new MigrateResult(flywayVersion, databaseName, String.join((CharSequence)", ", configuration.getSchemas()));
    }

    public static CleanResult createCleanResult(String databaseName) {
        String flywayVersion = VersionPrinter.getVersion();
        return new CleanResult(flywayVersion, databaseName);
    }

    public static UndoResult createUndoResult(String databaseName, Configuration configuration) {
        String flywayVersion = VersionPrinter.getVersion();
        return new UndoResult(flywayVersion, databaseName, String.join((CharSequence)", ", configuration.getSchemas()));
    }

    public static BaselineResult createBaselineResult(String databaseName) {
        String flywayVersion = VersionPrinter.getVersion();
        return new BaselineResult(flywayVersion, databaseName);
    }

    public static ValidateResult createValidateResult(String databaseName, ErrorDetails validationError, int validationCount, List<ValidateOutput> invalidMigrations, List<String> warnings) {
        String flywayVersion = VersionPrinter.getVersion();
        boolean validationSuccessful = validationError == null;
        String errorMessage = validationError == null ? null : validationError.errorMessage;
        ArrayList<ValidateOutput> invalidMigrationsList = invalidMigrations == null ? new ArrayList<ValidateOutput>() : invalidMigrations;
        return new ValidateResult(flywayVersion, databaseName, validationError, validationSuccessful, validationCount, invalidMigrationsList, warnings, errorMessage);
    }

    public static RepairResult createRepairResult(String databaseName) {
        String flywayVersion = VersionPrinter.getVersion();
        return new RepairResult(flywayVersion, databaseName);
    }

    private static String getDatabaseName(Configuration configuration, Database database) {
        try {
            Connection connection = configuration.getDataSource().getConnection();
            String catalog = connection.getCatalog();
            connection.close();
            return catalog != null ? catalog : database.getCatalog();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static InfoOutput createInfoOutput(Set<MigrationVersion> undoableVersions, MigrationInfo migrationInfo) {
        return new InfoOutput(CommandResultFactory.getCategory(migrationInfo), migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getType() != null ? migrationInfo.getType().toString() : "", migrationInfo.getInstalledOn() != null ? migrationInfo.getInstalledOn().toString() : "", migrationInfo.getInstalledOn() != null ? migrationInfo.getInstalledOn().toInstant().toString() : "", migrationInfo.getState().getDisplayName(), CommandResultFactory.getUndoableStatus(migrationInfo, undoableVersions), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", migrationInfo.getInstalledBy() != null ? migrationInfo.getInstalledBy() : "", migrationInfo.getExecutionTime() != null ? migrationInfo.getExecutionTime() : 0);
    }

    public static MigrateOutput createMigrateOutput(MigrationInfo migrationInfo, int executionTime) {
        return new MigrateOutput(CommandResultFactory.getCategory(migrationInfo), migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getType() != null ? migrationInfo.getType().toString() : "", migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", executionTime);
    }

    public static UndoOutput createUndoOutput(ResolvedMigration migrationInfo, int executionTime) {
        return new UndoOutput(migrationInfo.getVersion().getVersion(), migrationInfo.getDescription(), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", executionTime);
    }

    public static ValidateOutput createValidateOutput(MigrationInfo migrationInfo, ErrorDetails validateError) {
        return new ValidateOutput(migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", validateError);
    }

    public static RepairOutput createRepairOutput(MigrationInfo migrationInfo) {
        return new RepairOutput(migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "");
    }

    public static RepairOutput createRepairOutput(AppliedMigration am) {
        return new RepairOutput(am.getVersion() != null ? am.getVersion().getVersion() : "", am.getDescription(), "");
    }

    private static String getUndoableStatus(MigrationInfo migrationInfo, Set<MigrationVersion> undoableVersions) {
        return "";
    }

    private static Set<MigrationVersion> getUndoableVersions(MigrationInfo[] migrationInfos) {
        HashSet<MigrationVersion> result = new HashSet<MigrationVersion>();
        return result;
    }

    private static MigrationInfo[] removeAvailableUndos(MigrationInfo[] migrationInfos) {
        ArrayList<MigrationInfo> result = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            if (migrationInfo.getState().equals((Object)MigrationState.AVAILABLE)) continue;
            result.add(migrationInfo);
        }
        return result.toArray(new MigrationInfo[0]);
    }

    private static String getCategory(MigrationInfo migrationInfo) {
        if (migrationInfo.getType().isSynthetic()) {
            return "";
        }
        if (migrationInfo.getVersion() == null) {
            return "Repeatable";
        }
        return "Versioned";
    }
}

