/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.cloud.gcs;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.resource.gcs.GCSResource;
import org.flywaydb.core.internal.scanner.cloud.CloudScanner;

public class GCSScanner
extends CloudScanner {
    private static final Log LOG = LogFactory.getLog(GCSScanner.class);
    private boolean throwOnMissingLocations;

    public GCSScanner(Charset encoding, boolean throwOnMissingLocations) {
        super(encoding);
        this.throwOnMissingLocations = throwOnMissingLocations;
    }

    @Override
    public Collection<LoadableResource> scanForResources(Location location) {
        if (System.getenv("GOOGLE_APPLICATION_CREDENTIALS") == null) {
            String message = "Can't read location " + location + "; GOOGLE_APPLICATION_CREDENTIALS environment variable not set";
            if (this.throwOnMissingLocations) {
                throw new FlywayException(message);
            }
            LOG.error(message);
            return Collections.emptyList();
        }
        String bucketName = this.getBucketName(location);
        Storage storage = (Storage)StorageOptions.getDefaultInstance().getService();
        Bucket bucket = storage.get(bucketName, new Storage.BucketGetOption[0]);
        return this.getLoadableResources(bucketName, (Page<Blob>)bucket.list(new Storage.BlobListOption[0]));
    }

    private Collection<LoadableResource> getLoadableResources(String bucketName, Page<Blob> listObjectResult) {
        TreeSet<LoadableResource> resources = new TreeSet<LoadableResource>();
        for (Blob blob : listObjectResult.iterateAll()) {
            LOG.debug("Found GCS resource: " + bucketName.concat("/").concat(blob.getName()));
            resources.add(new GCSResource(blob, this.encoding));
        }
        return resources;
    }
}

