/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.databricks;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.flywaydb.community.database.databricks.DatabricksDatabase;
import org.flywaydb.community.database.databricks.DatabricksTable;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class DatabricksSchema
extends Schema<DatabricksDatabase, DatabricksTable> {
    public DatabricksSchema(JdbcTemplate jdbcTemplate, DatabricksDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    private List<String> fetchAllObjs(String obj, String column) throws SQLException {
        List tableInfos = this.jdbcTemplate.queryForList("show " + obj + "s from " + ((DatabricksDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Map tableInfo : tableInfos) {
            tableNames.add((String)tableInfo.get(column));
        }
        return tableNames;
    }

    private List<String> fetchAllSchemas() throws SQLException {
        List schemaInfos = this.jdbcTemplate.queryForList("show schemas", new Object[0]);
        ArrayList<String> schemaNames = new ArrayList<String>();
        for (Map schemaInfo : schemaInfos) {
            schemaNames.add((String)schemaInfo.get("databaseName"));
        }
        return schemaNames;
    }

    private List<String> fetchAllTables() throws SQLException {
        List<String> tables = this.fetchAllObjs("table", "tableName");
        List<String> views = this.fetchAllObjs("view", "viewName");
        return tables.stream().filter(t -> !views.contains(t)).toList();
    }

    protected boolean doExists() throws SQLException {
        return this.fetchAllSchemas().stream().anyMatch(schema -> Objects.equals(schema, this.name));
    }

    protected boolean doEmpty() throws SQLException {
        return this.fetchAllTables().size() == 0;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("create database if not exists " + ((DatabricksDatabase)this.database).quote(new String[]{this.name}) + ";", new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("drop database if exists " + ((DatabricksDatabase)this.database).quote(new String[]{this.name}) + " cascade;", new Object[0]);
    }

    protected void doClean() throws SQLException {
        for (String statement : this.generateDropStatements("TABLE", this.fetchAllTables())) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatements("VIEW", this.fetchAllObjs("VIEW", "viewName"))) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatements("FUNCTION", this.fetchAllObjs("USER FUNCTION", "function"))) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> generateDropStatements(String objType, List<String> names) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : names) {
            statements.add("drop " + objType + " if exists " + ((DatabricksDatabase)this.database).quote(new String[]{this.name, domainName}) + ";");
        }
        return statements;
    }

    protected DatabricksTable[] doAllTables() throws SQLException {
        List<String> tableNames = this.fetchAllTables();
        DatabricksTable[] tables = new DatabricksTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new DatabricksTable(this.jdbcTemplate, (DatabricksDatabase)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return new DatabricksTable(this.jdbcTemplate, (DatabricksDatabase)this.database, this, tableName);
    }
}

