/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.db2;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.database.db2.DB2Connection;

public class DB2Database
extends Database<DB2Connection> {
    public DB2Database(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected DB2Connection doGetConnection(Connection connection) {
        return new DB2Connection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("9.7");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("11.5", Tier.PREMIUM, configuration);
        this.recommendFlywayUpgradeIfNecessary("11.5");
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String tablespace = this.configuration.getTablespace() == null ? "" : " IN \"" + this.configuration.getTablespace() + "\"";
        return "CREATE TABLE " + String.valueOf(table) + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT TIMESTAMP NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" SMALLINT NOT NULL,\n    CONSTRAINT \"" + table.getName() + "_s\" CHECK (\"success\" in(0,1))\n)" + (this.getVersion().isAtLeast("10.5") ? "" : " ORGANIZE BY ROW") + tablespace + ";\nALTER TABLE " + String.valueOf(table) + " ADD CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\");\nCREATE INDEX \"" + table.getSchema().getName() + "\".\"" + table.getName() + "_s_idx\" ON " + String.valueOf(table) + " (\"success\") " + tablespace + ";" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "");
    }

    public String getSelectStatement(Table table) {
        return super.getSelectStatement(table) + " WITH UR";
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((DB2Connection)this.getMainConnection()).getJdbcTemplate().queryForString("select CURRENT_USER from sysibm.sysdummy1", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean useSingleConnection() {
        return false;
    }
}

