/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.ignite.thin;

import java.sql.SQLException;
import java.util.UUID;
import org.flywaydb.community.database.ignite.thin.IgniteThinDatabase;
import org.flywaydb.community.database.ignite.thin.IgniteThinSchema;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;

public class IgniteThinTable
extends Table<IgniteThinDatabase, IgniteThinSchema> {
    private static final Log LOG = LogFactory.getLog(IgniteThinTable.class);
    private final String tableLockString = UUID.randomUUID().toString();

    public IgniteThinTable(JdbcTemplate jdbcTemplate, IgniteThinDatabase database, IgniteThinSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((IgniteThinDatabase)this.database).quote(new String[]{((IgniteThinSchema)this.schema).getName(), this.name}) + " CASCADE", new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        return this.exists(null, this.schema, this.name, new String[0]);
    }

    protected void doLock() throws SQLException {
        if (this.lockDepth > 0) {
            return;
        }
        int retryCount = 0;
        do {
            try {
                if (this.insertLockingRow()) {
                    return;
                }
                ++retryCount;
                LOG.debug("Waiting for lock on " + String.valueOf((Object)this));
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (retryCount < 50);
        throw new FlywayException("Unable to obtain table lock - another Flyway instance may be running");
    }

    protected void doUnlock() throws SQLException {
        if (this.lockDepth > 1) {
            return;
        }
        int competingLocksTaken = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + String.valueOf((Object)this) + " WHERE " + ((IgniteThinDatabase)this.database).quote(new String[]{"version"}) + " != '" + this.tableLockString + "' AND " + ((IgniteThinDatabase)this.database).quote(new String[]{"description"}) + " = 'flyway-lock'", new String[0]);
        if (competingLocksTaken > 0) {
            throw new FlywayException("Internal error: on unlocking, a competing lock was found");
        }
        this.jdbcTemplate.executeStatement("DELETE FROM " + String.valueOf((Object)this) + " WHERE " + ((IgniteThinDatabase)this.database).quote(new String[]{"version"}) + " = '" + this.tableLockString + "' AND " + ((IgniteThinDatabase)this.database).quote(new String[]{"description"}) + " = 'flyway-lock'");
    }

    private boolean insertLockingRow() {
        Results results = this.jdbcTemplate.executeStatement("INSERT INTO " + String.valueOf((Object)this) + " VALUES (-100, '" + this.tableLockString + "', 'flyway-lock', '', '', 0, '', now(), 0, TRUE)");
        return results.getException() == null;
    }
}

