/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.questdb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.community.database.QuestDBDatabaseExtension;
import org.flywaydb.community.database.questdb.QuestDBDatabase;
import org.flywaydb.community.database.questdb.QuestDBParser;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;

public class QuestDBDatabaseType
extends BaseDatabaseType
implements CommunityDatabaseType {
    private static final Log LOG = LogFactory.getLog(QuestDBDatabaseType.class);

    public String getName() {
        return "QuestDB";
    }

    public int getNullType() {
        return 0;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:postgresql:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return "org.postgresql.Driver";
    }

    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        return "org.postgresql.Driver";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        if (!databaseProductName.startsWith("PostgreSQL")) return false;
        try (PreparedStatement stmt = connection.prepareStatement("select version()");
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return false;
            String version = rs.getString(1);
            boolean bl = version.endsWith("QuestDB");
            return bl;
        }
        catch (SQLException e) {
            LOG.error("Could not query catalog version from server");
            return false;
        }
    }

    public int getPriority() {
        return 1;
    }

    public QuestDBDatabase createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new QuestDBDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new QuestDBParser(configuration, parsingContext, 3);
    }

    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("user=");
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("password=");
    }

    public String getPluginVersion(Configuration config) {
        return QuestDBDatabaseExtension.readVersion();
    }
}

