/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.redshift.RedshiftDatabase;
import org.flywaydb.database.redshift.RedshiftSchema;

public class RedshiftConnection
extends org.flywaydb.core.internal.database.base.Connection<RedshiftDatabase> {
    RedshiftConnection(RedshiftDatabase database, Connection connection) {
        super((Database)database, connection);
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
    }

    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (schema.getName().equals(this.originalSchemaNameOrSearchPath) || this.originalSchemaNameOrSearchPath.startsWith(schema.getName() + ",") || !schema.exists()) {
                return;
            }
            if (StringUtils.hasText((String)this.originalSchemaNameOrSearchPath) && !"unset".equals(this.originalSchemaNameOrSearchPath)) {
                this.doChangeCurrentSchemaOrSearchPathTo(schema.toString() + "," + this.originalSchemaNameOrSearchPath);
            } else {
                this.doChangeCurrentSchemaOrSearchPathTo(schema.toString());
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error setting current schema to " + String.valueOf(schema), e);
        }
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        if ("unset".equals(schema)) {
            schema = "";
        }
        this.jdbcTemplate.execute("SELECT set_config('search_path', ?, false)", new Object[]{schema});
    }

    public Schema doGetCurrentSchema() throws SQLException {
        String currentSchema = this.jdbcTemplate.queryForString("SELECT current_schema()", new String[0]);
        String searchPath = this.getCurrentSchemaNameOrSearchPath();
        if (!StringUtils.hasText((String)currentSchema) && !StringUtils.hasText((String)searchPath)) {
            throw new FlywayException("Unable to determine current schema as search_path is empty. Set the current schema in currentSchema parameter of the JDBC URL or in Flyway's schemas property.");
        }
        String schema = StringUtils.hasText((String)currentSchema) ? currentSchema : searchPath;
        return this.getSchema(schema);
    }

    public Schema getSchema(String name) {
        return new RedshiftSchema(this.jdbcTemplate, (RedshiftDatabase)this.database, name);
    }
}

