/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.timeplus;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import org.flywaydb.community.database.timeplus.TimeplusDatabase;
import org.flywaydb.community.database.timeplus.TimeplusSchema;
import org.flywaydb.core.internal.database.base.Database;

public class TimeplusConnection
extends org.flywaydb.core.internal.database.base.Connection<TimeplusDatabase> {
    private static final String DEFAULT_CATALOG_TERM = "database";

    TimeplusConnection(TimeplusDatabase database, Connection connection) {
        super((Database)database, connection);
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        Connection jdbcConnection = this.getJdbcTemplate().getConnection();
        String currentSchema = this.useCatalog(jdbcConnection) ? jdbcConnection.getCatalog() : jdbcConnection.getSchema();
        return Optional.ofNullable(currentSchema).map(arg_0 -> ((TimeplusDatabase)((TimeplusDatabase)this.database)).unQuote(arg_0)).orElse(null);
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        Connection jdbcConnection = this.getJdbcTemplate().getConnection();
        if (this.useCatalog(jdbcConnection)) {
            jdbcConnection.setCatalog(schema);
        } else {
            jdbcConnection.setSchema(schema);
        }
    }

    protected boolean useCatalog(Connection jdbcConnection) throws SQLException {
        return DEFAULT_CATALOG_TERM.equals(jdbcConnection.getMetaData().getCatalogTerm());
    }

    public TimeplusSchema getSchema(String name) {
        return new TimeplusSchema(this.jdbcTemplate, (TimeplusDatabase)this.database, name);
    }
}

