/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.executors;

import lombok.Generated;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.nc.ConnectionType;
import org.flywaydb.core.internal.nc.Executor;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.nc.NativeConnectorsJdbc;

public class JdbcExecutor
implements Executor<SqlStatement, NativeConnectorsJdbc> {
    @Generated
    private static final Log LOG = LogFactory.getLog(JdbcExecutor.class);

    public void execute(NativeConnectorsJdbc experimentalDatabase, SqlStatement executionUnit, Configuration configuration) {
        if (configuration.isBatch()) {
            if (executionUnit.isBatchable()) {
                experimentalDatabase.addToBatch(executionUnit.getSql());
                if (experimentalDatabase.getBatchSize() >= 100) {
                    experimentalDatabase.doExecuteBatch();
                }
            } else {
                experimentalDatabase.doExecuteBatch();
                experimentalDatabase.doExecute(executionUnit.getSql(), configuration.isOutputQueryResults());
            }
        } else {
            experimentalDatabase.doExecute(executionUnit.getSql(), configuration.isOutputQueryResults());
        }
    }

    public void finishExecution(NativeConnectorsJdbc experimentalDatabase, Configuration configuration) {
        if (configuration.isBatch()) {
            experimentalDatabase.doExecuteBatch();
        }
    }

    public boolean canExecute(ConnectionType connectionType) {
        return connectionType == ConnectionType.JDBC;
    }

    public void appendErrorMessage(SqlStatement executionUnit, StringBuilder messageBuilder, boolean isDebugEnabled) {
        messageBuilder.append("Line       : ").append(executionUnit.getLineNumber()).append("\n");
        messageBuilder.append("Statement  : ").append(isDebugEnabled ? executionUnit.getSql() : "Run Flyway with -X option to see the actual statement causing the problem").append("\n");
    }
}

