/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.info;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.LoadableResourceMetadata;
import org.flywaydb.core.internal.nc.NativeConnectorsStateCalculator;
import org.flywaydb.core.internal.nc.schemahistory.ResolvedSchemaHistoryItem;
import org.flywaydb.core.internal.util.Pair;

public class CoreMigrationStateCalculator
implements NativeConnectorsStateCalculator {
    public MigrationState calculateState(Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata> migration, Collection<? extends Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> sortedMigrations, Configuration configuration) {
        if (migration.getLeft() == null) {
            return CoreMigrationStateCalculator.calculateNoSHTStates(migration, sortedMigrations, configuration);
        }
        return CoreMigrationStateCalculator.calculateSHTStates(migration, sortedMigrations);
    }

    private static MigrationState calculateNoSHTStates(Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata> migration, Collection<? extends Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> sortedMigrations, Configuration configuration) {
        Optional<MigrationVersion> baselineVersion = sortedMigrations.stream().filter(x -> x.getLeft() != null).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getType().isBaseline()).map(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getVersion()).findFirst();
        boolean baselinedSchema = baselineVersion.isPresent();
        if (baselineVersion.isEmpty()) {
            baselineVersion = sortedMigrations.stream().filter(x -> x.getRight() != null).filter(x -> ((LoadableResourceMetadata)x.getRight()).migrationType().isBaseline()).map(x -> ((LoadableResourceMetadata)x.getRight()).version()).max(MigrationVersion::compareTo);
        }
        if (baselineVersion.isEmpty() || ((LoadableResourceMetadata)migration.getRight()).isRepeatable() || ((LoadableResourceMetadata)migration.getRight()).version().isNewerThan(baselineVersion.get())) {
            MigrationVersion target = configuration.getTarget();
            if (((LoadableResourceMetadata)migration.getRight()).isRepeatable()) {
                return MigrationState.PENDING;
            }
            if (target != null && ((LoadableResourceMetadata)migration.getRight()).version().isNewerThan(target)) {
                return MigrationState.ABOVE_TARGET;
            }
            if (((LoadableResourceMetadata)migration.getRight()).migrationType().isUndo()) {
                return MigrationState.AVAILABLE;
            }
            if (((LoadableResourceMetadata)migration.getRight()).sqlScriptMetadata() != null && !((LoadableResourceMetadata)migration.getRight()).sqlScriptMetadata().shouldExecute()) {
                return MigrationState.IGNORED;
            }
            if (((LoadableResourceMetadata)migration.getRight()).migrationType().isBaseline() && baselinedSchema) {
                return MigrationState.IGNORED;
            }
            if (!configuration.isOutOfOrder()) {
                MigrationVersion highestSHTVersion = CoreMigrationStateCalculator.highestSHTVersion(sortedMigrations);
                if (((LoadableResourceMetadata)migration.getRight()).version().isNewerThan(highestSHTVersion)) {
                    return MigrationState.PENDING;
                }
                return MigrationState.IGNORED;
            }
            return MigrationState.PENDING;
        }
        if (((LoadableResourceMetadata)migration.getRight()).version().equals((Object)baselineVersion.get())) {
            return ((LoadableResourceMetadata)migration.getRight()).migrationType().isBaseline() && !baselinedSchema ? MigrationState.PENDING : MigrationState.BASELINE_IGNORED;
        }
        return MigrationState.BELOW_BASELINE;
    }

    private static MigrationState calculateSHTStates(Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata> migration, Collection<? extends Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> sortedMigrations) {
        if (((ResolvedSchemaHistoryItem)migration.getLeft()).getType() == CoreMigrationType.SCHEMA) {
            return MigrationState.SUCCESS;
        }
        if (((ResolvedSchemaHistoryItem)migration.getLeft()).getType().isBaseline()) {
            return ((ResolvedSchemaHistoryItem)migration.getLeft()).isSuccess() ? MigrationState.BASELINE : MigrationState.FAILED;
        }
        if (((ResolvedSchemaHistoryItem)migration.getLeft()).isSuccess()) {
            MigrationState repeatableState;
            MigrationState missingState;
            MigrationState lookAheadState = CoreMigrationStateCalculator.calculateLookAheadStates(migration, sortedMigrations);
            if (lookAheadState != null) {
                return lookAheadState;
            }
            if (migration.getRight() != null) {
                return MigrationState.SUCCESS;
            }
            if (((ResolvedSchemaHistoryItem)migration.getLeft()).isVersioned() && (missingState = CoreMigrationStateCalculator.calculateMissingStates(migration, sortedMigrations)) != null) {
                return missingState;
            }
            if (((ResolvedSchemaHistoryItem)migration.getLeft()).isRepeatable() && ((ResolvedSchemaHistoryItem)migration.getLeft()).isSuccess() && (repeatableState = CoreMigrationStateCalculator.calculateRepeatableStates(migration, sortedMigrations)) != null) {
                return repeatableState;
            }
            return MigrationState.SUCCESS;
        }
        if (migration.getRight() == null) {
            MigrationVersion maxLocalVersion = CoreMigrationStateCalculator.highestLocalVersion(sortedMigrations);
            if (((ResolvedSchemaHistoryItem)migration.getLeft()).isRepeatable()) {
                return MigrationState.MISSING_FAILED;
            }
            return ((ResolvedSchemaHistoryItem)migration.getLeft()).getVersion().isNewerThan(maxLocalVersion) ? MigrationState.FUTURE_FAILED : MigrationState.MISSING_FAILED;
        }
        return MigrationState.FAILED;
    }

    private static MigrationVersion highestLocalVersion(Collection<? extends Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> sortedMigrations) {
        return sortedMigrations.stream().filter(x -> x.getRight() != null).map(Pair::getRight).filter(LoadableResourceMetadata::isVersioned).filter(x -> !x.migrationType().isUndo()).map(LoadableResourceMetadata::version).max(Comparator.naturalOrder()).orElse(MigrationVersion.EMPTY);
    }

    private static MigrationVersion highestSHTVersion(Collection<? extends Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> sortedMigrations) {
        return sortedMigrations.stream().filter(x -> x.getLeft() != null).filter(x -> !CoreMigrationStateCalculator.hasFutureUndo((Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>)x, sortedMigrations)).map(Pair::getLeft).filter(ResolvedSchemaHistoryItem::isVersioned).filter(x -> !x.getType().isUndo()).map(ResolvedSchemaHistoryItem::getVersion).max(Comparator.naturalOrder()).orElse(MigrationVersion.EMPTY);
    }

    private static MigrationState calculateLookAheadStates(Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata> migration, Collection<? extends Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> sortedMigrations) {
        boolean outOfOrder;
        if (!((ResolvedSchemaHistoryItem)migration.getLeft()).getType().isUndo() && CoreMigrationStateCalculator.hasFutureUndo(migration, sortedMigrations)) {
            return MigrationState.UNDONE;
        }
        boolean futureDelete = sortedMigrations.stream().filter(x -> x.getLeft() != null).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getType() == CoreMigrationType.DELETE).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).isRepeatable() == ((ResolvedSchemaHistoryItem)migration.getLeft()).isRepeatable()).anyMatch(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).isRepeatable() ? ((ResolvedSchemaHistoryItem)x.getLeft()).getDescription().equals(((ResolvedSchemaHistoryItem)migration.getLeft()).getDescription()) : ((ResolvedSchemaHistoryItem)x.getLeft()).getVersion().equals((Object)((ResolvedSchemaHistoryItem)migration.getLeft()).getVersion()));
        if (futureDelete && ((ResolvedSchemaHistoryItem)migration.getLeft()).getType() != CoreMigrationType.DELETE) {
            return MigrationState.DELETED;
        }
        if (((ResolvedSchemaHistoryItem)migration.getLeft()).isVersioned() && !((ResolvedSchemaHistoryItem)migration.getLeft()).getType().isUndo() && (outOfOrder = sortedMigrations.stream().filter(x -> x.getLeft() != null).filter(x -> !((ResolvedSchemaHistoryItem)x.getLeft()).getType().isUndo()).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).isVersioned()).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getVersion().isNewerThan(((ResolvedSchemaHistoryItem)migration.getLeft()).getVersion())).anyMatch(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getInstalledRank() < ((ResolvedSchemaHistoryItem)migration.getLeft()).getInstalledRank()))) {
            return MigrationState.OUT_OF_ORDER;
        }
        return null;
    }

    private static boolean hasFutureUndo(Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata> migration, Collection<? extends Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> sortedMigrations) {
        return sortedMigrations.stream().filter(x -> x.getLeft() != null).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getType().isUndo()).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getInstalledRank() > ((ResolvedSchemaHistoryItem)migration.getLeft()).getInstalledRank()).anyMatch(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getVersion().equals((Object)((ResolvedSchemaHistoryItem)migration.getLeft()).getVersion()));
    }

    private static MigrationState calculateMissingStates(Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata> migration, Collection<? extends Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> sortedMigrations) {
        MigrationVersion latestLocalVersion = sortedMigrations.stream().filter(x -> x.getRight() != null).filter(x -> ((LoadableResourceMetadata)x.getRight()).isVersioned()).map(x -> ((LoadableResourceMetadata)x.getRight()).version()).sorted().findFirst().orElse(MigrationVersion.EMPTY);
        if (((ResolvedSchemaHistoryItem)migration.getLeft()).getVersion().isNewerThan(latestLocalVersion)) {
            return MigrationState.FUTURE_SUCCESS;
        }
        if (latestLocalVersion.isNewerThan(((ResolvedSchemaHistoryItem)migration.getLeft()).getVersion())) {
            return MigrationState.MISSING_SUCCESS;
        }
        return null;
    }

    private static MigrationState calculateRepeatableStates(Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata> migration, Collection<? extends Pair<ResolvedSchemaHistoryItem, LoadableResourceMetadata>> sortedMigrations) {
        boolean superseded = sortedMigrations.stream().filter(x -> x.getLeft() != null).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).isSuccess()).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).isRepeatable()).filter(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getDescription().equals(((ResolvedSchemaHistoryItem)migration.getLeft()).getDescription())).anyMatch(x -> ((ResolvedSchemaHistoryItem)x.getLeft()).getInstalledRank() > ((ResolvedSchemaHistoryItem)migration.getLeft()).getInstalledRank());
        if (superseded) {
            return MigrationState.SUPERSEDED;
        }
        boolean outdated = sortedMigrations.stream().filter(x -> x.getLeft() == null).filter(x -> ((LoadableResourceMetadata)x.getRight()).isRepeatable()).anyMatch(x -> ((LoadableResourceMetadata)x.getRight()).description().equals(((ResolvedSchemaHistoryItem)migration.getLeft()).getDescription()));
        if (outdated) {
            return MigrationState.OUTDATED;
        }
        if (migration.getRight() == null) {
            return MigrationState.MISSING_SUCCESS;
        }
        return null;
    }
}

