/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.info;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.MigrationFilter;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.internal.nc.NativeConnectorsMigrationInfoFilter;

public class NativeConnectorsMigrationInfoService
implements MigrationInfoService {
    private final MigrationInfo[] allMigrations;
    private final Configuration configuration;
    private final MigrationInfo[] applicableMigrations;
    private final String databaseName;
    private final Boolean allSchemasEmpty;

    public NativeConnectorsMigrationInfoService(MigrationInfo[] migrations, Configuration configuration, String databaseName, Boolean allSchemasEmpty) {
        this.allMigrations = migrations;
        this.configuration = configuration;
        this.allSchemasEmpty = allSchemasEmpty;
        this.applicableMigrations = this.getApplicableMigrations(migrations, configuration);
        this.databaseName = databaseName;
    }

    private MigrationInfo[] getApplicableMigrations(MigrationInfo[] migrations, Configuration configuration) {
        List filters = configuration.getPluginRegister().getLicensedInstancesOf(NativeConnectorsMigrationInfoFilter.class, configuration);
        MigrationInfo[] tempMigrations = Arrays.copyOf(migrations, migrations.length);
        for (NativeConnectorsMigrationInfoFilter filter : filters) {
            Predicate predicate = filter.getFilter(configuration);
            tempMigrations = (MigrationInfo[])Arrays.stream(tempMigrations).filter(predicate).toArray(MigrationInfo[]::new);
        }
        MigrationInfo[] applicableMigrations = tempMigrations;
        return applicableMigrations;
    }

    public MigrationInfo[] all() {
        return (MigrationInfo[])this.allMigrations.clone();
    }

    public MigrationInfo[] all(MigrationFilter filter) {
        return (MigrationInfo[])Arrays.stream(this.allMigrations).filter(arg_0 -> ((MigrationFilter)filter).matches(arg_0)).toArray(MigrationInfo[]::new);
    }

    public MigrationInfo current() {
        MigrationInfo current = null;
        for (MigrationInfo migrationInfo : this.allMigrations) {
            if (!migrationInfo.getState().isApplied() || MigrationState.DELETED.equals((Object)migrationInfo.getState()) || migrationInfo.getType().equals((Object)CoreMigrationType.DELETE) || MigrationState.UNDONE.equals((Object)migrationInfo.getState()) || migrationInfo.getType().isUndo() || !migrationInfo.isVersioned() || current != null && migrationInfo.getVersion().compareTo(current.getVersion()) <= 0) continue;
            current = migrationInfo;
        }
        if (current != null) {
            return current;
        }
        for (int i = this.allMigrations.length - 1; i >= 0; --i) {
            MigrationInfo migrationInfo = this.allMigrations[i];
            if (!migrationInfo.getState().isApplied() || MigrationState.DELETED.equals((Object)migrationInfo.getState()) || migrationInfo.getType().equals((Object)CoreMigrationType.DELETE) || MigrationState.UNDONE.equals((Object)migrationInfo.getState()) || migrationInfo.getVersion() != null) continue;
            return migrationInfo;
        }
        return null;
    }

    public MigrationInfo[] pending() {
        return (MigrationInfo[])Arrays.stream(this.applicableMigrations).filter(migrationInfo -> MigrationState.PENDING == migrationInfo.getState()).toArray(MigrationInfo[]::new);
    }

    public MigrationInfo[] applied() {
        return (MigrationInfo[])Arrays.stream(this.applicableMigrations).filter(x -> x.getState().isApplied()).toArray(MigrationInfo[]::new);
    }

    public InfoResult getInfoResult() {
        return this.getInfoResult(this.all());
    }

    public InfoResult getInfoResult(MigrationFilter filter) {
        return this.getInfoResult(this.all(filter));
    }

    private InfoResult getInfoResult(MigrationInfo[] infos) {
        return CommandResultFactory.createInfoResult((Configuration)this.configuration, (String)this.databaseName, (MigrationInfo[])infos, (MigrationInfo)this.current(), (boolean)this.allSchemasEmpty);
    }
}

