/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.scanners;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.nc.NativeConnectorsMigrationScanner;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.resource.ResourceNameParser;
import org.flywaydb.core.internal.resource.filesystem.FileSystemResource;
import org.flywaydb.core.internal.scanner.filesystem.DirectoryValidationResult;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.scanners.ScannerUtils;

public abstract class BaseSqlMigrationScanner
implements NativeConnectorsMigrationScanner {
    @Generated
    private static final Log LOG = LogFactory.getLog(BaseSqlMigrationScanner.class);

    protected Collection<Pair<LoadableResource, SqlScriptMetadata>> scanFromFileSystem(File dir, Location location, Configuration configuration, ParsingContext parsingContext) {
        DirectoryValidationResult validationResult = this.getDirectoryValidationResult(dir);
        String locationType = location.getPrefix().substring(0, location.getPrefix().length() - 1);
        boolean isFilesystem = "filesystem:".equals(location.getPrefix());
        if (validationResult != DirectoryValidationResult.VALID) {
            if (configuration.isFailOnMissingLocations()) {
                throw new FlywayException("Failed to find " + locationType + " location: " + location.getRootPath() + " (" + String.valueOf(validationResult) + ")");
            }
            String message = "Skipping " + locationType + " location: " + location.getRootPath() + " (" + String.valueOf(validationResult) + ")";
            if (isFilesystem) {
                LOG.error(message);
            } else {
                LOG.debug(message);
            }
            return Collections.emptyList();
        }
        Set<String> resourceNames = this.findResourceNamesFromFileSystem(location.getRootPath(), dir, configuration.isFailOnMissingLocations(), configuration.isValidateMigrationNaming(), new ResourceNameParser(configuration), isFilesystem, configuration.getSqlMigrationSuffixes());
        return resourceNames.stream().filter(path -> this.matchesPath((String)path, location)).map(resourceName -> this.processResource(location, configuration, (String)resourceName, parsingContext)).toList();
    }

    abstract boolean matchesPath(String var1, Location var2);

    private Pair<LoadableResource, SqlScriptMetadata> processResource(Location location, Configuration configuration, String resourceName, ParsingContext parsingContext) {
        boolean detectEncodingForThisResource = configuration.isDetectEncoding();
        Charset encoding = configuration.getEncoding();
        Object encodingBlurb = "";
        SqlScriptMetadata metadata = null;
        if (new File(resourceName + ".conf").exists() && (metadata = this.getSqlScriptMetadata(location, configuration, resourceName, parsingContext)).encoding() != null) {
            encoding = Charset.forName(metadata.encoding());
            detectEncodingForThisResource = false;
            encodingBlurb = " (with overriding encoding " + String.valueOf(encoding) + ")";
        }
        LOG.debug("Found " + location.getPrefix().substring(0, location.getPrefix().length() - 1) + " resource: " + resourceName + (String)encodingBlurb);
        FileSystemResource fileSystemResource = new FileSystemResource(location, resourceName, encoding, detectEncodingForThisResource, configuration.isStream());
        return Pair.of((Object)fileSystemResource, (Object)metadata);
    }

    private SqlScriptMetadata getSqlScriptMetadata(Location location, Configuration configuration, String resourceName, ParsingContext parsingContext) {
        FileSystemResource metadataResource = new FileSystemResource(location, resourceName + ".conf", configuration.getEncoding(), false);
        return SqlScriptMetadata.fromResource((LoadableResource)metadataResource, (Parser)new MetadataParser(configuration, parsingContext), (Configuration)configuration);
    }

    private DirectoryValidationResult getDirectoryValidationResult(File directory) {
        if (!directory.exists()) {
            return DirectoryValidationResult.NOT_FOUND;
        }
        if (!directory.canRead()) {
            return DirectoryValidationResult.NOT_READABLE;
        }
        if (!directory.isDirectory()) {
            return DirectoryValidationResult.NOT_A_DIRECTORY;
        }
        return DirectoryValidationResult.VALID;
    }

    private Set<String> findResourceNamesFromFileSystem(String scanRootLocation, File folder, boolean throwOnMissingLocations, boolean validateMigrationNaming, ResourceNameParser resourceNameParser, boolean isFileSystem, String ... sqlMigrationSuffixes) {
        String path = folder.getPath();
        LOG.debug("Scanning for resources in path: " + folder.getPath() + " (" + scanRootLocation + ")");
        TreeSet<String> resourceNames = new TreeSet<String>();
        String fileOrClasspath = isFileSystem ? "filesystem" : "classpath";
        File[] files = folder.listFiles();
        if (files == null) {
            if (throwOnMissingLocations) {
                throw new FlywayException("Failed to find " + fileOrClasspath + " location: " + path + " (" + String.valueOf(DirectoryValidationResult.UNABLE_TO_ACCESS_FOLDER) + ")");
            }
            String message = "Skipping " + fileOrClasspath + " location: " + path + " (" + String.valueOf(DirectoryValidationResult.UNABLE_TO_ACCESS_FOLDER) + ")";
            if (isFileSystem) {
                LOG.error(message);
            } else {
                LOG.debug(message);
            }
            return Collections.emptySet();
        }
        List<Pair> fileList = Arrays.stream(files).filter(File::canRead).map(file -> Pair.of((Object)file, (Object)resourceNameParser.parse(file.getName()))).toList();
        List<Pair<String, ResourceName>> resources = fileList.stream().map(pair -> Pair.of((Object)((File)pair.getLeft()).getName(), (Object)((ResourceName)pair.getRight()))).toList();
        ScannerUtils.validateMigrationNaming(resources, validateMigrationNaming, sqlMigrationSuffixes);
        fileList.stream().filter(pair -> ((ResourceName)pair.getRight()).isValid() && !"".equals(((ResourceName)pair.getRight()).getSuffix())).forEach(pair -> resourceNames.add(((File)pair.getLeft()).getPath()));
        Arrays.stream(files).filter(File::canRead).filter(File::isDirectory).forEach(file -> {
            if (file.isHidden()) {
                LOG.debug("Skipping hidden directory: " + file.getAbsolutePath());
            } else {
                resourceNames.addAll(this.findResourceNamesFromFileSystem(scanRootLocation, (File)file, throwOnMissingLocations, validateMigrationNaming, resourceNameParser, isFileSystem, sqlMigrationSuffixes));
            }
        });
        return resourceNames;
    }

    private static class MetadataParser
    extends Parser {
        private MetadataParser(Configuration configuration, ParsingContext parsingContext) {
            super(configuration, parsingContext, 0);
        }
    }
}

