/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.reports.html;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.CollectionsUtils;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.reports.api.extensibility.HtmlRenderer;
import org.flywaydb.reports.api.extensibility.HtmlReportSummary;
import org.flywaydb.reports.html.HoldingTabMetadata;
import org.flywaydb.reports.output.DashboardResult;
import org.flywaydb.reports.output.HoldingResult;
import org.flywaydb.reports.utils.HtmlUtils;

public class HtmlReportGenerator {
    @Generated
    private static final Log LOG = LogFactory.getLog(HtmlReportGenerator.class);
    private static final List<HoldingTabMetadata> HOLDING_TAB_METADATA = Arrays.asList(new HoldingTabMetadata("changes", "ENTERPRISE"), new HoldingTabMetadata("drift", "ENTERPRISE"), new HoldingTabMetadata("migrate", "OSS"), new HoldingTabMetadata("dryrun", "TEAMS", "ENTERPRISE"), new HoldingTabMetadata("code", "OSS"));
    private static final String INSTALL_DIR = ClassUtils.getInstallDir(HtmlReportGenerator.class);

    public static String generateHtml(CompositeResult<? extends HtmlResult> result, Configuration config) {
        Map<LocalDateTime, List<HtmlResult>> groupedResults = result.individualResults.stream().collect(Collectors.groupingBy(HtmlResult::getTimestamp));
        ArrayList<LocalDateTime> timestamps = new ArrayList<LocalDateTime>(groupedResults.keySet());
        StringBuilder content = new StringBuilder(HtmlReportGenerator.getBeginning(timestamps));
        for (LocalDateTime timestamp : timestamps) {
            List<HtmlResult> groupedResult = groupedResults.get(timestamp);
            DashboardResult dashboardResult = new DashboardResult();
            dashboardResult.setOperation("dashboard");
            dashboardResult.setResults(groupedResult);
            dashboardResult.setTimestamp(timestamp);
            groupedResult.add(0, dashboardResult);
            groupedResult.addAll(HtmlReportGenerator.getHoldingResults(groupedResult, timestamp, config));
            ArrayList<HtmlResult> htmlResults = new ArrayList<HtmlResult>();
            for (HtmlResult htmlResult : groupedResult) {
                if (htmlResult.isLicenseFailed()) continue;
                htmlResults.add(htmlResult);
            }
            String formattedTimestamp = timestamp.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT));
            content.append(HtmlReportGenerator.getPage(formattedTimestamp, htmlResults, config));
        }
        return content.append(HtmlReportGenerator.getEnd()).toString();
    }

    private static Collection<HoldingResult> getHoldingResults(Collection<? extends HtmlResult> groupedResult, LocalDateTime timestamp, Configuration config) {
        String currentTier = LicenseGuard.getTierAsString((Configuration)config);
        ArrayList<HoldingResult> holdingResults = new ArrayList<HoldingResult>();
        for (HoldingTabMetadata holdingTabMetadata : HOLDING_TAB_METADATA) {
            String holdingTab = holdingTabMetadata.name();
            if (!groupedResult.stream().noneMatch(t -> holdingTab.equals(t.getOperation()) && !t.isLicenseFailed())) continue;
            String htmlFile = FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)("assets/report/holdingTabs/" + holdingTab + ".html"));
            HoldingResult holdingResult = new HoldingResult();
            if (!Objects.equals(holdingTabMetadata.supportedEditions().get(0), "OSS") && !holdingTabMetadata.supportedEditions().contains(currentTier)) {
                htmlFile = FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)("assets/report/upgradeTabs/" + holdingTab + ".html"));
                groupedResult.stream().filter(t -> t.getOperation().equals(holdingTab)).findFirst().ifPresent(x -> holdingResult.setException(x.exceptionObject));
            }
            String tabTitle = FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)("assets/report/holdingTabs/" + holdingTab + ".txt"));
            holdingResult.setTimestamp(timestamp);
            holdingResult.setTabTitle(tabTitle.trim());
            holdingResult.setBodyText(htmlFile);
            holdingResult.setOperation(holdingTab);
            holdingResults.add(holdingResult);
        }
        return holdingResults;
    }

    private static String getBeginning(List<LocalDateTime> timestamps) {
        return "<!doctype html>\n<html lang=\"en\">\n<head><meta charset=\"utf-8\">\n<style>\n" + HtmlReportGenerator.getCodeStyle() + "</style>\n</head>\n<body>\n" + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/AddFilled.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/Calendar.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/CheckFilled.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/ClockOutlined.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/Database.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/DeleteFilled.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/Document.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/EditFilled.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/ErrorFilled.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/FeedbackOutlined.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/flyway-upgrade-icon.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/InfoOutlined.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/PipelineFilled.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/ScriptOutlined.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/upgrade.svg") + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/icons/WarningFilled.svg") + " <div class=\"container\">  <div class=\"header\">    <div class=\"flywayLogo headerElement\"></div>\n    <div class=\"headerElement leftPaddedElement\">Flyway Reports</div>      <div class=\"redgateText\"><a class='unstyledLink' href='https://www.redgate.com'>redgate</a></div>  </div>\n  <div class=\"content\">\n" + HtmlReportGenerator.getDropdown(timestamps);
    }

    private static String getDropdown(List<LocalDateTime> timestamps) {
        Collections.sort(timestamps);
        StringBuilder options = new StringBuilder();
        for (int i = 0; i < timestamps.size(); ++i) {
            String timestamp = timestamps.get(i).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT));
            options.append("<option value=\"").append(timestamp).append("\"");
            if (i == timestamps.size() - 1) {
                options.append(" selected=\"true\"");
            }
            options.append(">").append(timestamp).append("</option>\n");
        }
        return "<div class=\"dropdown\">\n<label for=\"dropdown\">Report generated:</label>\n<select onchange=\"onTimestampClick(event, this.value)\" id=\"dropdown\">\n" + String.valueOf(options) + "</select>\n</div>\n";
    }

    public static HtmlRenderer<HtmlResult> getRenderer(HtmlResult htmlResult, Configuration config) {
        HtmlRenderer result = config.getPluginRegister().getInstancesOf(HtmlRenderer.class).stream().map(x -> x).filter(t -> t.getType().isAssignableFrom(htmlResult.getClass())).findFirst().orElse(null);
        if (result == null) {
            System.out.println("No renderer found for " + htmlResult.getClass().getName());
        }
        return result;
    }

    private static String getPage(String timestamp, Iterable<? extends HtmlResult> results, Configuration config) {
        StringBuilder content = new StringBuilder();
        content.append("<div class=\"page ").append(timestamp).append("\">\n");
        content.append(HtmlReportGenerator.getTabs(results, config));
        int tabCount = 0;
        for (HtmlResult htmlResult : results) {
            content.append(HtmlReportGenerator.renderTab(htmlResult, config, tabCount));
            ++tabCount;
        }
        return content.append("</div>\n").toString();
    }

    private static String getTabs(Iterable<? extends HtmlResult> result, Configuration config) {
        StringBuilder tabs = new StringBuilder();
        int tabCount = 0;
        for (HtmlResult htmlResult : result) {
            String id2 = htmlResult.getOperation() + "-" + tabCount + "_" + HtmlUtils.getFormattedTimestamp(htmlResult);
            StringBuilder button = new StringBuilder("<button class=\"tab\" onclick=\"onTabClick(event, '").append(HtmlReportGenerator.getTabId(htmlResult, config, tabCount)).append("','").append(id2).append("')\"");
            button.append(" id=\"").append(id2).append("\">");
            String tabTitle = "";
            HtmlRenderer<HtmlResult> correctRenderer = HtmlReportGenerator.getRenderer(htmlResult, config);
            if (correctRenderer != null) {
                tabTitle = correctRenderer.tabTitle(htmlResult, config);
            }
            tabs.append((CharSequence)button).append("<h4>").append(tabTitle).append("</h4>").append("</button>\n");
            ++tabCount;
        }
        return "<div class=\"tabs\">\n" + String.valueOf(tabs) + "</div>";
    }

    private static String renderTab(HtmlResult result, Configuration config, int tabCount) {
        HtmlRenderer<HtmlResult> renderer = HtmlReportGenerator.getRenderer(result, config);
        return HtmlReportGenerator.getTabOpening(result, config, tabCount) + HtmlReportGenerator.renderTabSummary(result, config) + renderer.render(result, config) + HtmlReportGenerator.getTabEnding(result);
    }

    private static String renderTabSummary(HtmlResult result, Configuration config) {
        HtmlRenderer<HtmlResult> renderer = HtmlReportGenerator.getRenderer(result, config);
        List<HtmlReportSummary> summaries = renderer.getHtmlSummary(result, config);
        if (!CollectionsUtils.hasItems(summaries)) {
            return "";
        }
        StringBuilder html = new StringBuilder("<div class='summaryHeader'>");
        for (HtmlReportSummary s : summaries) {
            html.append("<div class='summaryDiv ").append(s.getCssClass()).append("'><div class='summaryDivContent'><span class='summaryIcon'><svg fill=\"none\"><use href=\"#").append(s.getIcon()).append("\"/></svg></span><span class='summaryText'>").append(s.getSummaryText()).append("</span></div></div>");
        }
        html.append("</div>");
        return html.toString();
    }

    private static String getTabOpening(HtmlResult result, Configuration config, int tabCount) {
        return "<div id=\"" + HtmlReportGenerator.getTabId(result, config, tabCount) + "\" class=\"tabcontent\">\n";
    }

    private static String getTabEnding(HtmlResult result) {
        Object htmlResult = "";
        if (result.getException() != null) {
            htmlResult = (String)htmlResult + "<div class=\"error\">\n<pre class=\"exception\">Flyway Exception: " + result.getException() + "</pre>\n</div>\n";
        }
        return (String)htmlResult + "</div>\n";
    }

    public static String getTabId(HtmlResult result, Configuration config, int tabCount) {
        HtmlRenderer<HtmlResult> correctRenderer = HtmlReportGenerator.getRenderer(result, config);
        return (correctRenderer.tabTitle(result, config) + "_" + tabCount + "_" + HtmlUtils.getFormattedTimestamp(result)).replace(" ", "");
    }

    private static String getEnd() {
        Object html = "</div>\n";
        html = (String)html + FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/footer.html");
        html = (String)html + "</div></body>\n" + HtmlReportGenerator.getScript() + "</html>\n";
        return html;
    }

    private static String getScript() {
        return FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/reportScript.html");
    }

    private static String getCodeStyle() {
        return FileUtils.readAsStringFallbackToResource((String)INSTALL_DIR, (String)"assets/report/report.css");
    }
}

