/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.reports.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.reports.ReportDetails;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.JsonUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.reports.utils.HtmlUtils;
import org.flywaydb.reports.utils.ReportsDeserializer;

public class OperationsReportUtils {
    @Generated
    private static final Log LOG = LogFactory.getLog(OperationsReportUtils.class);
    private static final String DEFAULT_REPORT_FILENAME = "report";
    private static final String JSON_REPORT_EXTENSION = ".json";
    private static final String HTML_REPORT_EXTENSION = ".html";
    private static final String HTM_REPORT_EXTENSION = ".htm";
    private static final Pattern REPORT_FILE_PATTERN = Pattern.compile("\\.html?$");

    static String getBaseFilename(String filename) {
        if (REPORT_FILE_PATTERN.matcher(filename).find()) {
            return filename.replaceAll(REPORT_FILE_PATTERN.pattern(), "");
        }
        return filename;
    }

    static String createHtmlReport(Configuration configuration, CompositeResult<? extends HtmlResult> htmlCompositeResult, String tmpHtmlReportFilename) {
        return HtmlUtils.toHtmlFile(tmpHtmlReportFilename, htmlCompositeResult, configuration);
    }

    static String createJsonReport(CompositeResult<HtmlResult> htmlCompositeResult, String tmpJsonReportFilename) {
        return JsonUtils.jsonToFile((String)tmpJsonReportFilename, htmlCompositeResult);
    }

    public static ReportDetails writeReport(Configuration configuration, OperationResult filteredResults, LocalDateTime executionTime) {
        ReportDetails reportDetails = new ReportDetails();
        CompositeResult<HtmlResult> htmlCompositeResult = OperationsReportUtils.removeRedundantHtmlResults(OperationsReportUtils.flattenHtmlResults(filteredResults), configuration.isReportEnabled());
        if (htmlCompositeResult != null && !htmlCompositeResult.individualResults.isEmpty()) {
            htmlCompositeResult.individualResults.forEach(r -> r.setTimestamp(executionTime));
            String reportFilename = configuration.getReportFilename();
            String baseReportFilename = OperationsReportUtils.getBaseFilename(reportFilename);
            Object tmpJsonReportFilename = baseReportFilename + JSON_REPORT_EXTENSION;
            Object tmpHtmlReportFilename = baseReportFilename + (reportFilename.endsWith(HTM_REPORT_EXTENSION) ? HTM_REPORT_EXTENSION : HTML_REPORT_EXTENSION);
            tmpJsonReportFilename = ConfigUtils.getFilenameWithWorkingDirectory((String)tmpJsonReportFilename, (Configuration)configuration);
            tmpHtmlReportFilename = ConfigUtils.getFilenameWithWorkingDirectory((String)tmpHtmlReportFilename, (Configuration)configuration);
            try {
                htmlCompositeResult = OperationsReportUtils.appendIfExists((String)tmpJsonReportFilename, htmlCompositeResult, configuration.getPluginRegister());
                reportDetails.setJsonReportFilename(OperationsReportUtils.createJsonReport(htmlCompositeResult, (String)tmpJsonReportFilename));
                reportDetails.setHtmlReportFilename(OperationsReportUtils.createHtmlReport(configuration, htmlCompositeResult, (String)tmpHtmlReportFilename));
            }
            catch (FlywayException e) {
                if (DEFAULT_REPORT_FILENAME.equals(reportFilename)) {
                    LOG.warn("Unable to create default report files.");
                    if (LogFactory.isDebugEnabled()) {
                        e.printStackTrace(System.out);
                    }
                }
                LOG.error("Unable to create report files", (Exception)((Object)e));
            }
            if (reportDetails.getHtmlReportFilename() != null) {
                LOG.info("A Flyway report has been generated here: " + reportDetails.getHtmlReportFilename());
            }
        }
        return reportDetails;
    }

    public static <T extends OperationResult> CompositeResult<T> appendIfExists(String filename, CompositeResult<T> newObject, PluginRegister pluginRegister) {
        CompositeResult existingObject;
        Path path = Path.of(filename, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return newObject;
        }
        String jsonText = FileUtils.readAsString((Path)path);
        if (!StringUtils.hasText((String)jsonText)) {
            return newObject;
        }
        JsonMapper mapper = JsonUtils.getJsonMapper();
        ReportsDeserializer reportsDeserializer = new ReportsDeserializer(pluginRegister);
        mapper.registerModule((Module)new SimpleModule().addDeserializer(OperationResult.class, (JsonDeserializer)reportsDeserializer));
        try {
            existingObject = (CompositeResult)mapper.readValue(jsonText, new TypeReference<CompositeResult<T>>(){});
        }
        catch (Exception e) {
            throw new FlywayException("Unable to read filename: " + filename, (Throwable)e);
        }
        if (existingObject == null || existingObject.individualResults.isEmpty()) {
            throw new FlywayException("Unable to deserialize existing JSON file: " + filename);
        }
        existingObject.individualResults.addAll(newObject.individualResults);
        return existingObject;
    }

    public static OperationResult filterHtmlResults(OperationResult result) {
        if (result instanceof CompositeResult) {
            List<OperationResult> filteredResults = ((CompositeResult)result).individualResults.stream().map(OperationsReportUtils::filterHtmlResults).filter(Objects::nonNull).toList();
            if (filteredResults.isEmpty()) {
                return null;
            }
            CompositeResult htmlCompositeResult = new CompositeResult();
            htmlCompositeResult.individualResults.addAll(filteredResults);
            return htmlCompositeResult;
        }
        if (result instanceof HtmlResult) {
            return result;
        }
        return null;
    }

    public static Exception getAggregateExceptions(OperationResult result) {
        if (result instanceof CompositeResult) {
            Exception aggregate = null;
            List<Exception> exceptions = ((CompositeResult)result).individualResults.stream().map(OperationsReportUtils::getAggregateExceptions).filter(Objects::nonNull).toList();
            for (Exception e : exceptions) {
                if (aggregate == null) {
                    aggregate = e;
                    continue;
                }
                aggregate.addSuppressed(e);
            }
            return aggregate;
        }
        if (result instanceof HtmlResult) {
            return ((HtmlResult)result).exceptionObject;
        }
        return null;
    }

    static CompositeResult<HtmlResult> flattenHtmlResults(OperationResult result) {
        CompositeResult htmlCompositeResult = new CompositeResult();
        if (result instanceof CompositeResult) {
            List htmlResults = ((CompositeResult)result).individualResults.stream().map(OperationsReportUtils::flattenHtmlResults).flatMap(r -> r.individualResults.stream()).toList();
            htmlCompositeResult.individualResults.addAll(htmlResults);
        } else if (result instanceof HtmlResult) {
            htmlCompositeResult.individualResults.add((HtmlResult)result);
        }
        return htmlCompositeResult;
    }

    static CompositeResult<HtmlResult> removeRedundantHtmlResults(CompositeResult<HtmlResult> htmlCompositeResult, boolean isReportEnabled) {
        if (htmlCompositeResult == null || htmlCompositeResult.individualResults == null) {
            return null;
        }
        if (!isReportEnabled) {
            htmlCompositeResult.individualResults = htmlCompositeResult.individualResults.stream().filter(r -> List.of("changes", "drift", "dryrun", "code").contains(r.getOperation().toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        return htmlCompositeResult;
    }

    @Generated
    private OperationsReportUtils() {
    }
}

