/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.exception.FlywayValidateException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.TimeFormat;
import org.flywaydb.core.internal.util.ValidatePatternUtils;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.nc.info.NativeConnectorsMigrationInfoService;
import org.flywaydb.nc.preparation.PreparationContext;
import org.flywaydb.nc.utils.VerbUtils;
import org.flywaydb.verb.baseline.BaselineVerbExtension;
import org.flywaydb.verb.migrate.MigrationExecutionGroup;
import org.flywaydb.verb.migrate.migrators.Migrator;
import org.flywaydb.verb.migrate.migrators.MigratorFactory;
import org.flywaydb.verb.schemas.SchemasVerbExtension;
import org.flywaydb.verb.validate.ValidateVerbExtension;

public class MigrateVerbExtension
implements VerbExtension {
    @Generated
    private static final Log LOG = LogFactory.getLog(MigrateVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "migrate".equals(verb);
    }

    public Object executeVerb(Configuration configuration) {
        PreparationContext context = PreparationContext.get((Configuration)configuration, (boolean)false);
        if (configuration.isValidateOnMigrate()) {
            MigrateVerbExtension.validate(configuration);
            context.refresh(configuration);
        }
        NativeConnectorsDatabase database = context.getDatabase();
        if (configuration.isCreateSchemas()) {
            try {
                SchemasVerbExtension schemasVerbExtension = new SchemasVerbExtension();
                schemasVerbExtension.useCaching();
                schemasVerbExtension.executeVerb(configuration);
                context.refresh(configuration);
            }
            catch (NoClassDefFoundError e) {
                throw new FlywayException("Schemas verb extension is required for creating schemas but is not present", (Throwable)e);
            }
        } else if (!database.isSchemaExists(database.getCurrentSchema())) {
            LOG.warn("The configuration option 'createSchemas' is false.\nEven though Flyway is configured not to create any schemas, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://rd.gt/4iUkpm1");
        }
        if (!database.schemaHistoryTableExists(configuration.getTable())) {
            NativeConnectorsDatabase finalDatabase = database;
            List<String> populatedSchemas = Arrays.stream(VerbUtils.getAllSchemas((String[])configuration.getSchemas(), (String)database.getCurrentSchema())).filter(arg_0 -> ((NativeConnectorsDatabase)database).isSchemaExists(arg_0)).filter(x -> !finalDatabase.isSchemaEmpty(x)).toList();
            if (populatedSchemas.isEmpty() && configuration.isBaselineOnMigrate()) {
                LOG.info("All configured schemas are empty; baseline operation skipped. A baseline or migration script with a lower version than the baseline version may execute if available. Check the Schemas parameter if this is not intended.");
            }
            if (!populatedSchemas.isEmpty() && !configuration.isSkipExecutingMigrations()) {
                if (configuration.isBaselineOnMigrate()) {
                    BaselineVerbExtension baselineVerbExtension = new BaselineVerbExtension();
                    baselineVerbExtension.useCaching();
                    baselineVerbExtension.executeVerb(configuration);
                    context.refresh(configuration);
                } else {
                    throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(populatedSchemas) + " but no schema history table. Use baseline() or set baselineOnMigrate to true to initialize the schema history table.", (ErrorCode)CoreErrorCode.NON_EMPTY_SCHEMA_WITHOUT_SCHEMA_HISTORY_TABLE);
                }
            }
        }
        CallbackManager callbackManager = new CallbackManager(configuration, context.getCallbackResources());
        database.createSchemaHistoryTableIfNotExists(configuration);
        MigrateResult migrateResult = new MigrateResult(VersionPrinter.getVersion(), database.getDatabaseMetaData().databaseName(), "", database.getDatabaseType());
        NativeConnectorsMigrationInfoService migrationInfoService = new NativeConnectorsMigrationInfoService(context.getMigrations(), configuration, database.getName(), database.allSchemasEmpty(VerbUtils.getAllSchemas((String[])configuration.getSchemas(), (String)database.getCurrentSchema())));
        MigrationInfo current = migrationInfoService.current();
        MigrationVersion initialSchemaVersion = current != null && current.isVersioned() ? current.getVersion() : MigrationVersion.EMPTY;
        migrateResult.initialSchemaVersion = initialSchemaVersion.getVersion();
        MigrationInfo[] allPendingMigrations = migrationInfoService.pending();
        if (allPendingMigrations.length > 1 && configuration.getTarget().equals((Object)MigrationVersion.NEXT)) {
            allPendingMigrations = Arrays.copyOf(allPendingMigrations, 1);
        }
        LOG.info("Current version of schema " + database.doQuote(database.getCurrentSchema()) + ": " + String.valueOf(initialSchemaVersion));
        MigrateVerbExtension.secondValidate((MigrationInfoService)migrationInfoService, configuration, database.doQuote(database.getCurrentSchema()));
        if (configuration.isOutOfOrder()) {
            String outOfOrderWarning = "outOfOrder mode is active. Migration of schema " + database.doQuote(database.getCurrentSchema()) + " may not be reproducible.";
            LOG.warn(outOfOrderWarning);
            migrateResult.addWarning(outOfOrderWarning);
        } else {
            allPendingMigrations = this.removeOutOfOrderPendingMigrations(allPendingMigrations);
        }
        Migrator migrator = MigratorFactory.getMigrator(database);
        List<MigrationExecutionGroup> executionGroups = migrator.createGroups(allPendingMigrations, configuration, database, migrateResult, context.getParsingContext());
        callbackManager.handleEvent(Event.BEFORE_MIGRATE, database, configuration, context.getParsingContext());
        try {
            ProgressLogger progress = configuration.createProgress("migrate");
            int installedRank = context.getSchemaHistoryModel().calculateInstalledRank((MigrationType)CoreMigrationType.SQL);
            progress.pushSteps(allPendingMigrations.length);
            for (MigrationExecutionGroup executionGroup : executionGroups) {
                installedRank = migrator.doExecutionGroup(configuration, executionGroup, database, migrateResult, context.getParsingContext(), installedRank, callbackManager, progress);
            }
        }
        catch (FlywayException e) {
            callbackManager.handleEvent(Event.AFTER_MIGRATE_ERROR, database, configuration, context.getParsingContext());
            throw e;
        }
        this.logSummary(migrateResult.migrationsExecuted, migrateResult.getTotalMigrationTime(), migrateResult.targetSchemaVersion, database);
        if (migrateResult.migrationsExecuted > 0) {
            callbackManager.handleEvent(Event.AFTER_MIGRATE_APPLIED, database, configuration, context.getParsingContext());
        }
        callbackManager.handleEvent(Event.AFTER_MIGRATE, database, configuration, context.getParsingContext());
        return migrateResult;
    }

    private static void validate(Configuration configuration) {
        FluentConfiguration validateConfig = new FluentConfiguration().configuration(configuration);
        ArrayList<ValidatePattern> ignorePatterns = new ArrayList<ValidatePattern>(Arrays.asList(configuration.getIgnoreMigrationPatterns()));
        ignorePatterns.add(ValidatePattern.fromPattern((String)"*:pending"));
        validateConfig.ignoreMigrationPatterns((ValidatePattern[])ignorePatterns.toArray(ValidatePattern[]::new));
        ValidateVerbExtension validateVerbExtension = new ValidateVerbExtension();
        validateVerbExtension.useCaching();
        ValidateResult validateResult = (ValidateResult)validateVerbExtension.executeVerb((Configuration)validateConfig);
        if (!validateResult.validationSuccessful) {
            throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
        }
    }

    private static void secondValidate(MigrationInfoService infoService, Configuration configuration, String schema) {
        List<MigrationInfo> failed = Arrays.stream(infoService.all()).filter(migrationInfo -> migrationInfo.getState().isFailed()).toList();
        if (failed.isEmpty()) {
            return;
        }
        MigrationInfo firstFailure = failed.get(0);
        if (failed.size() == 1 && firstFailure.getState() == MigrationState.FUTURE_FAILED && ValidatePatternUtils.isFutureIgnored((ValidatePattern[])configuration.getIgnoreMigrationPatterns())) {
            LOG.warn("Schema " + schema + " contains a failed future migration to version " + String.valueOf(firstFailure.getVersion()) + " !");
            return;
        }
        if (firstFailure.isRepeatable()) {
            throw new FlywayException("Schema " + schema + " contains a failed repeatable migration (\"" + firstFailure.getDescription() + "\") !");
        }
        throw new FlywayException("Schema " + schema + " contains a failed migration to version " + String.valueOf(firstFailure.getVersion()) + " !");
    }

    private MigrationInfo[] removeOutOfOrderPendingMigrations(MigrationInfo[] migrations) {
        ArrayList<MigrationInfo> result = new ArrayList<MigrationInfo>();
        for (MigrationInfo migration : migrations) {
            if (migration.isVersioned() && !result.isEmpty() && !migration.getVersion().isNewerThan(((MigrationInfo)result.get(result.size() - 1)).getVersion())) continue;
            result.add(migration);
        }
        return (MigrationInfo[])result.toArray(MigrationInfo[]::new);
    }

    private void logSummary(int migrationSuccessCount, long executionTime, String targetVersion, NativeConnectorsDatabase experimentalDatabase) {
        String schemaName = experimentalDatabase.doQuote(experimentalDatabase.getCurrentSchema());
        if (migrationSuccessCount == 0) {
            LOG.info("Schema " + schemaName + " is up to date. No migration necessary.");
            return;
        }
        Object targetText = targetVersion != null ? ", now at version v" + targetVersion : "";
        String migrationText = "migration" + StringUtils.pluralizeSuffix((long)migrationSuccessCount);
        LOG.info("Successfully applied %d %s to schema %s%s (execution time %s)".formatted(migrationSuccessCount, migrationText, schemaName, targetText, TimeFormat.format((long)executionTime)));
    }
}

