/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate.migrators;

import java.util.List;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.internal.nc.ConnectionType;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.nc.NativeConnectorsHybrid;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.verb.migrate.MigrationExecutionGroup;
import org.flywaydb.verb.migrate.migrators.ApiMigrator;
import org.flywaydb.verb.migrate.migrators.ExecutableMigrator;
import org.flywaydb.verb.migrate.migrators.JdbcMigrator;
import org.flywaydb.verb.migrate.migrators.Migrator;

public class HybridMigrator
extends Migrator<NativeConnectorsHybrid> {
    private Migrator getMigrator(NativeConnectorsHybrid database) {
        return switch (database.getDatabaseMetaData().connectionType()) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionType.API -> new ApiMigrator();
            case ConnectionType.JDBC -> new JdbcMigrator();
            case ConnectionType.EXECUTABLE -> new ExecutableMigrator();
        };
    }

    @Override
    public List<MigrationExecutionGroup> createGroups(MigrationInfo[] allPendingMigrations, Configuration configuration, NativeConnectorsHybrid experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext) {
        Migrator migrator;
        return migrator.createGroups(allPendingMigrations, configuration, (migrator = this.getMigrator(experimentalDatabase)) instanceof JdbcMigrator ? experimentalDatabase.toNativeConnectorsJdbc() : experimentalDatabase, migrateResult, parsingContext);
    }

    @Override
    public int doExecutionGroup(Configuration configuration, MigrationExecutionGroup executionGroup, NativeConnectorsHybrid experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext, int installedRank, CallbackManager callbackManager, ProgressLogger progress) {
        Migrator migrator;
        return migrator.doExecutionGroup(configuration, executionGroup, (migrator = this.getMigrator(experimentalDatabase)) instanceof JdbcMigrator ? experimentalDatabase.toNativeConnectorsJdbc() : experimentalDatabase, migrateResult, parsingContext, installedRank, callbackManager, progress);
    }
}

