/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.cuppa.junit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.forgerock.cuppa.ReporterSupport;
import org.forgerock.cuppa.Runner;
import org.forgerock.cuppa.junit.ReportJUnitAdapter;
import org.forgerock.cuppa.model.Test;
import org.forgerock.cuppa.model.TestBlock;
import org.forgerock.cuppa.reporters.Reporter;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

public final class CuppaRunner
extends org.junit.runner.Runner {
    private final Class<?> testClass;
    private final Runner runner = new Runner();
    private final TestBlock rootBlock;

    public CuppaRunner(Class<?> annotatedClass) {
        this.testClass = annotatedClass;
        this.rootBlock = this.runner.defineTests(Collections.singletonList(annotatedClass));
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((String)this.testClass.getName(), (Serializable)((Object)this.rootBlock.description), (Annotation[])new Annotation[0]);
        this.rootBlock.testBlocks.forEach(b -> description.addChild(this.getDescriptionOfDescribeBlock((TestBlock)b, Collections.singletonList(this.rootBlock))));
        return description;
    }

    private Description getDescriptionOfDescribeBlock(TestBlock testBlock, List<TestBlock> parents) {
        Description description = Description.createSuiteDescription((String)ReporterSupport.getDescription((TestBlock)testBlock), (Serializable)((Object)ReporterSupport.getFullDescription((TestBlock)testBlock, parents)), (Annotation[])new Annotation[0]);
        List newParents = Stream.concat(parents.stream(), Stream.of(testBlock)).collect(Collectors.toList());
        testBlock.tests.forEach(test -> description.addChild(Description.createTestDescription((String)test.testClass.getName(), (String)test.description, (Serializable)((Object)ReporterSupport.getFullDescription((Test)test, (List)newParents)))));
        testBlock.testBlocks.forEach(b -> description.addChild(this.getDescriptionOfDescribeBlock((TestBlock)b, newParents)));
        return description;
    }

    public void run(RunNotifier notifier) {
        this.runner.run(this.rootBlock, (Reporter)new ReportJUnitAdapter(notifier));
    }
}

