/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.cuppa.junit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import org.forgerock.cuppa.ReporterSupport;
import org.forgerock.cuppa.model.Hook;
import org.forgerock.cuppa.model.Test;
import org.forgerock.cuppa.model.TestBlock;
import org.forgerock.cuppa.reporters.Reporter;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

final class ReportJUnitAdapter
implements Reporter {
    private final RunNotifier notifier;

    ReportJUnitAdapter(RunNotifier notifier) {
        this.notifier = notifier;
    }

    public void hookFail(Hook hook, List<TestBlock> parents, Throwable cause) {
        ReporterSupport.filterStackTrace((Throwable)cause);
        this.notifier.fireTestFailure(new Failure(Description.createTestDescription((String)hook.testClass.getName(), (String)ReporterSupport.getFullDescription((Hook)hook, parents), (Annotation[])new Annotation[0]), cause));
    }

    public void testStart(Test test, List<TestBlock> parents) {
        this.notifier.fireTestStarted(this.getDescription(test, parents));
    }

    public void testEnd(Test test, List<TestBlock> parents) {
        this.notifier.fireTestFinished(this.getDescription(test, parents));
    }

    public void testFail(Test test, List<TestBlock> parents, Throwable e) {
        ReporterSupport.filterStackTrace((Throwable)e);
        this.notifier.fireTestFailure(new Failure(this.getDescription(test, parents), e));
    }

    public void testPending(Test test, List<TestBlock> parents) {
        this.notifier.fireTestIgnored(this.getDescription(test, parents));
    }

    public void testSkip(Test test, List<TestBlock> parents) {
        this.notifier.fireTestIgnored(this.getDescription(test, parents));
    }

    private Description getDescription(Test test, List<TestBlock> parents) {
        return Description.createTestDescription((String)test.testClass.getName(), (String)test.description, (Serializable)((Object)ReporterSupport.getFullDescription((Test)test, parents)));
    }
}

