/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.ClientDataRequest;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.gatein.cdi.PortletFilterUtil;
import org.gatein.cdi.wrappers.request.HttpServletActionRequestWrapper;
import org.gatein.cdi.wrappers.request.HttpServletEventRequestWrapper;
import org.gatein.cdi.wrappers.request.HttpServletRenderRequestWrapper;
import org.gatein.cdi.wrappers.request.HttpServletResourceRequestWrapper;
import org.gatein.cdi.wrappers.response.HttpServletActionResponseWrapper;
import org.gatein.cdi.wrappers.response.HttpServletEventResponseWrapper;
import org.gatein.cdi.wrappers.response.HttpServletRenderResponseWrapper;
import org.gatein.cdi.wrappers.response.HttpServletResourceResponseWrapper;

public class PortletCDIResponseFilter
implements ActionFilter,
EventFilter,
ResourceFilter,
RenderFilter {
    private boolean wrapMultipartRequests = false;

    public void init(FilterConfig filterConfig) throws PortletException {
        String enabled = filterConfig.getInitParameter("org.gatein.cdi.ENABLE_MULTIPART_REQUEST_WRAPPING");
        if (enabled != null) {
            this.wrapMultipartRequests = Boolean.parseBoolean(enabled);
        }
    }

    public void destroy() {
    }

    public void doFilter(ActionRequest request, ActionResponse response, FilterChain chain) throws IOException, PortletException {
        if (!this.wrapMultipartRequests && PortletFilterUtil.isMultipartRequest((ClientDataRequest)request)) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter((ActionRequest)new HttpServletActionRequestWrapper(request), (ActionResponse)new HttpServletActionResponseWrapper(response));
        }
    }

    public void doFilter(EventRequest request, EventResponse response, FilterChain chain) throws IOException, PortletException {
        chain.doFilter((EventRequest)new HttpServletEventRequestWrapper(request), (EventResponse)new HttpServletEventResponseWrapper(response));
    }

    public void doFilter(RenderRequest request, RenderResponse response, FilterChain chain) throws IOException, PortletException {
        chain.doFilter((RenderRequest)new HttpServletRenderRequestWrapper(request), (RenderResponse)new HttpServletRenderResponseWrapper(response));
    }

    public void doFilter(ResourceRequest request, ResourceResponse response, FilterChain chain) throws IOException, PortletException {
        if (!this.wrapMultipartRequests && PortletFilterUtil.isMultipartRequest((ClientDataRequest)request)) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter((ResourceRequest)new HttpServletResourceRequestWrapper(request), (ResourceResponse)new HttpServletResourceResponseWrapper(response));
        }
    }
}

