/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi.contexts.beanstore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gatein.cdi.contexts.beanstore.AbstractBeanStore;
import org.gatein.cdi.contexts.beanstore.BeanStoreInstance;
import org.gatein.cdi.contexts.beanstore.LockStore;
import org.gatein.cdi.contexts.beanstore.LockedBean;

public class SessionBeanStore
extends AbstractBeanStore {
    private static final String PREFIX = SessionBeanStore.class.getName();
    private static final String DELIM = "#";
    private static final ThreadLocal<LockStore> CURRENT_LOCK_STORE = new ThreadLocal();
    private volatile transient LockStore lockStore;
    private final HttpServletRequest request;
    private final HttpSession session;

    public SessionBeanStore(HttpServletRequest request) {
        this(request, null);
    }

    public SessionBeanStore(HttpSession session) {
        this(null, session);
    }

    private SessionBeanStore(HttpServletRequest request, HttpSession session) {
        this.request = request;
        this.session = session;
    }

    @Override
    public <T> BeanStoreInstance<T> getBean(String id) {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return null;
        }
        return (BeanStoreInstance)session.getAttribute(SessionBeanStore.prefix(id));
    }

    @Override
    public <T> void put(String id, BeanStoreInstance<T> instance) {
        HttpSession session = this.getSession(true);
        if (session != null) {
            session.setAttribute(SessionBeanStore.prefix(id), instance);
        }
    }

    @Override
    public LockedBean lock(String id) {
        return this.getLockStore().lock(id);
    }

    @Override
    public void destroy(String windowId) {
        for (String id : this) {
            if (!id.startsWith(windowId)) continue;
            this.destroyBean(this.getBean(id));
            this.removeAttribute(id);
        }
    }

    @Override
    public void destroy() {
        for (String id : this) {
            this.destroyBean(this.getBean(id));
            this.removeAttribute(id);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return SessionBeanStore.getIds(this.getSession(false)).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public LockStore getLockStore() {
        LockStore lockStore = this.lockStore;
        if (lockStore != null) return lockStore;
        lockStore = CURRENT_LOCK_STORE.get();
        if (lockStore != null) {
            return lockStore;
        }
        HttpSession session = this.getSession(false);
        if (session == null) {
            lockStore = new LockStore();
            CURRENT_LOCK_STORE.set(lockStore);
            try {
                session = this.getSession(true);
            }
            finally {
                CURRENT_LOCK_STORE.remove();
            }
        }
        if ((lockStore = (LockStore)session.getAttribute(LockStore.SESSION_KEY)) == null) {
            Class<SessionBeanStore> clazz = SessionBeanStore.class;
            // MONITORENTER : org.gatein.cdi.contexts.beanstore.SessionBeanStore.class
            lockStore = (LockStore)session.getAttribute(LockStore.SESSION_KEY);
            if (lockStore == null) {
                lockStore = new LockStore();
                session.setAttribute(LockStore.SESSION_KEY, (Object)lockStore);
            }
            // MONITOREXIT : clazz
        }
        this.lockStore = lockStore;
        return lockStore;
    }

    public HttpSession getSession(boolean create) {
        return this.session != null ? this.session : this.request.getSession(create);
    }

    private void removeAttribute(String id) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(SessionBeanStore.prefix(id));
        }
    }

    private static List<String> getIds(HttpSession session) {
        if (session == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        Enumeration enumeration = session.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String attributeName = (String)enumeration.nextElement();
            if (!attributeName.startsWith(PREFIX)) continue;
            list.add(SessionBeanStore.deprefix(attributeName));
        }
        return list;
    }

    private static String prefix(String id) {
        return PREFIX + DELIM + id;
    }

    private static String deprefix(String attributeName) {
        return attributeName.substring(PREFIX.length() + DELIM.length());
    }
}

