/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi.contexts;

import java.lang.annotation.Annotation;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gatein.api.cdi.context.PortletRedisplayScoped;
import org.gatein.cdi.contexts.AbstractCDIPortletContext;
import org.gatein.cdi.contexts.PortletRedisplayedContext;
import org.gatein.cdi.contexts.PortletRequestLifecycle;
import org.gatein.cdi.contexts.beanstore.ResourceTempBeanStore;
import org.gatein.cdi.contexts.beanstore.SessionBeanStore;

public class PortletRedisplayedContextImpl
extends AbstractCDIPortletContext
implements PortletRedisplayedContext {
    private static final String TRANSITION_PREFIX = PortletRequestLifecycle.class.getName();
    private static final String TRANSITION_DELIM = "#";

    public PortletRedisplayedContextImpl() {
        super(true);
    }

    public Class<? extends Annotation> getScope() {
        return PortletRedisplayScoped.class;
    }

    @Override
    public void transition(HttpServletRequest request, String windowId, PortletRequestLifecycle.State state) {
        if (this.getBeanStore() == null) {
            if (state.isPhase("RESOURCE_PHASE")) {
                this.setBeanStore(new ResourceTempBeanStore(request));
            } else {
                this.setBeanStore(new SessionBeanStore(request));
            }
        }
        String attributeName = PortletRedisplayedContextImpl.prefix(windowId);
        if (state.isPhase("RESOURCE_PHASE")) {
            attributeName = Thread.currentThread().getId() + attributeName;
        }
        SessionBeanStore store = (SessionBeanStore)this.getBeanStore();
        HttpSession session = store.getSession(true);
        PortletRequestLifecycle lifecycle = this.getLifecycle(windowId);
        if (lifecycle == null) {
            lifecycle = (PortletRequestLifecycle)session.getAttribute(attributeName);
            if (lifecycle == null) {
                lifecycle = new PortletRequestLifecycle();
            } else if (lifecycle.size() > 6) {
                this.destroy(windowId);
                lifecycle = new PortletRequestLifecycle();
            }
        }
        if (state.started()) {
            if (state.isPhase("ACTION_PHASE")) {
                this.destroy(windowId);
                lifecycle = new PortletRequestLifecycle();
            } else if (state.isPhase("EVENT_PHASE") && lifecycle.last() == null) {
                this.destroy(windowId);
                lifecycle = new PortletRequestLifecycle();
            }
        } else if (state.ended() && state.isPhase("RENDER_PHASE", "RESOURCE_PHASE")) {
            lifecycle = null;
            if (state.isPhase("RESOURCE_PHASE")) {
                this.destroy(windowId);
            }
            this.setBeanStore(null);
        }
        if (lifecycle != null) {
            lifecycle.addNext(state);
            session.setAttribute(attributeName, (Object)lifecycle);
        } else {
            session.removeAttribute(attributeName);
        }
        this.setCurrentLifecycle(windowId, lifecycle);
    }

    @Override
    public void dissociate(HttpSession session) {
        this.setBeanStore(new SessionBeanStore(session));
        this.destroy();
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(TRANSITION_PREFIX)) continue;
            session.removeAttribute(name);
        }
    }

    private static String prefix(String id) {
        return TRANSITION_PREFIX + TRANSITION_DELIM + id;
    }
}

