/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.portlet.Portlet;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.ServletContext;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectAddedEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectLifeCycleEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedPortletContainer;
import org.gatein.pc.portlet.container.managed.ManagedPortletFilter;
import org.gatein.pc.portlet.impl.jsr168.PortletFilterImpl;

public class CDIInjectionListener
implements ManagedObjectRegistryEventListener {
    private final Logger log = LoggerFactory.getLogger(CDIInjectionListener.class);
    private static final String BEAN_MGR_ATTRIBUTE = "javax.enterprise.inject.spi.BeanManager";
    private static final String SERVLET_BEAN_MGR_ATTRIBUTE = "org.jboss.weld.environment.servlet.javax.enterprise.inject.spi.BeanManager";
    private Map<String, CDIMetaData> cdiMetaDataMap = new ConcurrentHashMap<String, CDIMetaData>();
    private List<Class<? extends PortletFilter>> filterClasses = new ArrayList<Class<? extends PortletFilter>>();

    public CDIInjectionListener() {
        this.filterClasses.add(ActionFilter.class);
        this.filterClasses.add(EventFilter.class);
        this.filterClasses.add(RenderFilter.class);
        this.filterClasses.add(ResourceFilter.class);
    }

    public void onEvent(ManagedObjectRegistryEvent event) {
        block12: {
            LifeCycleStatus status;
            ManagedObject managedObject;
            block13: {
                block10: {
                    ManagedObject managedObject2;
                    block11: {
                        if (!(event instanceof ManagedObjectAddedEvent)) break block10;
                        managedObject2 = ((ManagedObjectAddedEvent)event).getManagedObject();
                        if (!(managedObject2 instanceof ManagedPortletContainer)) break block11;
                        ManagedPortletContainer managedPortletContainer = (ManagedPortletContainer)managedObject2;
                        PortletApplication portletApp = managedPortletContainer.getManagedPortletApplication().getPortletApplication();
                        this.createMetaData(managedPortletContainer.getId(), portletApp);
                        break block12;
                    }
                    if (!(managedObject2 instanceof ManagedPortletFilter)) break block12;
                    ManagedPortletFilter managedPortletFilter = (ManagedPortletFilter)managedObject2;
                    PortletApplication portletApp = managedPortletFilter.getManagedPortletApplication().getPortletApplication();
                    this.createMetaData(managedPortletFilter.getId(), portletApp);
                    break block12;
                }
                if (!(event instanceof ManagedObjectLifeCycleEvent)) break block12;
                ManagedObjectLifeCycleEvent lifeCycleEvent = (ManagedObjectLifeCycleEvent)event;
                managedObject = lifeCycleEvent.getManagedObject();
                status = lifeCycleEvent.getStatus();
                if (!(managedObject instanceof ManagedPortletContainer)) break block13;
                if (LifeCycleStatus.STARTED == status || LifeCycleStatus.INITIALIZED == status) {
                    return;
                }
                ManagedPortletContainer managedPortletContainer = (ManagedPortletContainer)managedObject;
                CDIMetaData cdiMetaData = this.cdiMetaDataMap.get(managedPortletContainer.getId());
                if (!cdiMetaData.cdiInjectionEnabled) {
                    return;
                }
                Portlet portlet = managedPortletContainer.getPortletInstance();
                if (null == portlet) break block12;
                if (null != portlet.getClass() && "javax.portlet.faces.GenericFacesPortlet".equals(portlet.getClass().getName())) {
                    cdiMetaData.cdiInjectionEnabled = false;
                    this.cdiMetaDataMap.put(cdiMetaData.key, cdiMetaData);
                    return;
                }
                PortletApplication portletApp = managedPortletContainer.getManagedPortletApplication().getPortletApplication();
                if (!cdiMetaData.injectionPerformed) {
                    this.performInjection(portlet, cdiMetaData, portletApp.getContext().getServletContext());
                } else {
                    this.performCleanup(portlet, cdiMetaData, portletApp.getContext().getServletContext());
                }
                break block12;
            }
            if (managedObject instanceof ManagedPortletFilter) {
                if (LifeCycleStatus.INITIALIZED == status) {
                    return;
                }
                ManagedPortletFilter managedPortletFilter = (ManagedPortletFilter)managedObject;
                CDIMetaData cdiMetaData = this.cdiMetaDataMap.get(managedPortletFilter.getId());
                if (!cdiMetaData.cdiInjectionEnabled) {
                    return;
                }
                PortletFilterImpl portletFilterImpl = (PortletFilterImpl)managedPortletFilter.getPortletFilter();
                for (Class<? extends PortletFilter> type : this.filterClasses) {
                    PortletFilter portletFilterInstance = (PortletFilter)portletFilterImpl.instance(type);
                    if (null == portletFilterInstance) continue;
                    PortletApplication portletApp = managedPortletFilter.getManagedPortletApplication().getPortletApplication();
                    if (LifeCycleStatus.STARTED == status && !cdiMetaData.injectionPerformed) {
                        this.performInjection(portletFilterInstance, cdiMetaData, portletApp.getContext().getServletContext());
                        break;
                    }
                    if (LifeCycleStatus.CREATED != status || !cdiMetaData.injectionPerformed) break;
                    this.performCleanup(portletFilterInstance, cdiMetaData, portletApp.getContext().getServletContext());
                    break;
                }
            }
        }
    }

    private void createMetaData(String id, PortletApplication portletApp) {
        CDIMetaData metaData = new CDIMetaData();
        metaData.key = id;
        if (null != portletApp.getContext().getServletContext().getAttribute(BEAN_MGR_ATTRIBUTE)) {
            metaData.cdiInjectionEnabled = true;
        } else {
            Object beanManager = portletApp.getContext().getServletContext().getAttribute(SERVLET_BEAN_MGR_ATTRIBUTE);
            if (null != beanManager) {
                metaData.cdiInjectionEnabled = true;
                portletApp.getContext().getServletContext().setAttribute(BEAN_MGR_ATTRIBUTE, beanManager);
            }
        }
        this.cdiMetaDataMap.put(id, metaData);
    }

    private void performInjection(Object instance, CDIMetaData metaData, ServletContext servletContext) {
        Object beanManagerObject = servletContext.getAttribute(BEAN_MGR_ATTRIBUTE);
        if (null == beanManagerObject) {
            this.log.error((Object)"Unable to retrieve BeanManager from ServletContext");
            return;
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(servletContext.getClassLoader());
        BeanManager beanManager = (BeanManager)beanManagerObject;
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        InjectionTarget injectionTarget = beanManager.createInjectionTarget(beanManager.createAnnotatedType(instance.getClass()));
        injectionTarget.inject(instance, creationalContext);
        Thread.currentThread().setContextClassLoader(oldCL);
        metaData.injectionPerformed = true;
        metaData.creationalContext = creationalContext;
        metaData.injectionTarget = injectionTarget;
        this.cdiMetaDataMap.put(metaData.key, metaData);
    }

    private void performCleanup(Object instance, CDIMetaData metaData, ServletContext servletContext) {
        InjectionTarget injectionTarget = metaData.injectionTarget;
        CreationalContext creationalContext = metaData.creationalContext;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(servletContext.getClassLoader());
        if (null != injectionTarget) {
            injectionTarget.dispose(instance);
            metaData.injectionTarget = null;
        }
        if (null != creationalContext) {
            creationalContext.release();
            metaData.creationalContext = null;
        }
        Thread.currentThread().setContextClassLoader(oldCL);
        metaData.injectionPerformed = false;
        this.cdiMetaDataMap.put(metaData.key, metaData);
    }

    private class CDIMetaData {
        private String key;
        private boolean cdiInjectionEnabled = false;
        private boolean injectionPerformed = false;
        private InjectionTarget injectionTarget;
        private CreationalContext creationalContext;

        private CDIMetaData() {
        }
    }
}

