/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.wsrp.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.gatein.common.util.ParameterValidation;
import org.gatein.integration.wsrp.structure.PortalStructureAccess;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.ui.UIComponent;
import org.gatein.mop.api.workspace.ui.UIContainer;
import org.gatein.mop.api.workspace.ui.UIWindow;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.wsrp.api.context.ConsumerStructureProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOPConsumerStructureProvider
extends Listener<DataStorage, Page>
implements ConsumerStructureProvider {
    private final PortalStructureAccess structureAccess;
    private Map<String, PageInfo> pageInfos;
    private boolean pagesHaveBeenInitialized;

    public MOPConsumerStructureProvider(PortalStructureAccess structureAccess) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)structureAccess, (String)"PortalStructureAccess");
        this.structureAccess = structureAccess;
        this.pageInfos = new HashMap<String, PageInfo>();
    }

    public List<String> getPageIdentifiers() {
        if (!this.pagesHaveBeenInitialized) {
            Collection<org.gatein.mop.api.workspace.Page> pages = this.structureAccess.getPages();
            for (org.gatein.mop.api.workspace.Page page : pages) {
                this.addPage(page);
            }
            this.pagesHaveBeenInitialized = true;
        }
        LinkedList<String> identifiers = new LinkedList<String>(this.pageInfos.keySet());
        Collections.sort(identifiers);
        return identifiers;
    }

    private void addPage(org.gatein.mop.api.workspace.Page page) {
        Described described = (Described)page.adapt(Described.class);
        PageInfo pageInfo = new PageInfo(page.getObjectId(), described.getName(), page.getName());
        this.pageInfos.put(pageInfo.getName(), pageInfo);
        UIContainer container = page.getRootComponent();
        this.processContainer(container, pageInfo);
        Collection children = page.getChildren();
        if (ParameterValidation.existsAndIsNotEmpty((Collection)children)) {
            for (org.gatein.mop.api.workspace.Page child : children) {
                this.addPage(child);
            }
        }
    }

    public List<String> getWindowIdentifiersFor(String pageId) {
        PageInfo pageInfo = this.pageInfos.get(pageId);
        if (pageInfo == null) {
            throw new IllegalArgumentException("Page '" + pageId + "' does not exist.");
        }
        return pageInfo.getChildrenWindows();
    }

    private void processContainer(UIContainer container, PageInfo pageInfo) {
        if (container != null) {
            List components = container.getComponents();
            for (UIComponent component : components) {
                ObjectType type = component.getObjectType();
                if (ObjectType.WINDOW.equals(type)) {
                    Described described = (Described)component.adapt(Described.class);
                    String name = described.getName();
                    pageInfo.addWindow(name, component.getObjectId());
                    continue;
                }
                if (!ObjectType.CONTAINER.equals(type)) continue;
                this.processContainer((UIContainer)component, pageInfo);
            }
        }
    }

    public void assignPortletToWindow(PortletContext portletContext, String windowId, String pageId, String exportedPortletHandle) {
        PageInfo pageInfo = this.pageInfos.get(pageId);
        String uuid = pageInfo.getWindowUUID(windowId);
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)uuid, (String)("UUID for " + windowId));
        UIWindow window = this.structureAccess.getWindowFrom(uuid);
        WSRP wsrp = new WSRP();
        String portletId = portletContext.getId();
        wsrp.setPortletId(portletId);
        if (portletContext instanceof StatefulPortletContext) {
            StatefulPortletContext context = (StatefulPortletContext)portletContext;
            if (PortletStateType.OPAQUE.equals(context.getType())) {
                wsrp.setState((byte[])context.getState());
            } else {
                throw new IllegalArgumentException("Don't know how to deal with state: " + context.getState());
            }
        }
        Customization customization = window.getCustomization();
        customization.destroy();
        window.customize(WSRP.CONTENT_TYPE, portletId, (Object)wsrp);
        Described described = (Described)window.adapt(Described.class);
        String newName = exportedPortletHandle + " (remote)";
        described.setName(newName);
        pageInfo.updateWindowName(windowId, newName);
        this.structureAccess.saveChangesTo(window);
    }

    public void onEvent(Event<DataStorage, Page> event) throws Exception {
        String eventName = event.getEventName();
        Page portalPage = (Page)event.getData();
        org.gatein.mop.api.workspace.Page page = this.structureAccess.getPageFrom(portalPage);
        if (page == null && DataStorage.PAGE_REMOVED.equals(eventName)) {
            this.removePage(portalPage.getTitle(), portalPage.getName());
            return;
        }
        if (page != null) {
            if (DataStorage.PAGE_CREATED.equals(eventName)) {
                this.addPage(page);
            } else if (DataStorage.PAGE_UPDATED.equals(eventName)) {
                this.removePage(page);
                this.addPage(page);
            }
        }
    }

    private void removePage(org.gatein.mop.api.workspace.Page page) {
        Described described = (Described)page.adapt(Described.class);
        String name = described.getName();
        this.removePage(name, page.getName());
    }

    private void removePage(String name, String internalName) {
        PageInfo pageInfo = this.pageInfos.get(name);
        if (pageInfo != null && internalName.equals(pageInfo.getInternalName())) {
            this.pageInfos.remove(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PageInfo {
        private final String uuid;
        private final Map<String, String> childrenWindows = new HashMap<String, String>();
        private final String name;
        private final String internalName;

        private PageInfo(String uuid, String name, String internalName) {
            this.uuid = uuid;
            this.name = name;
            this.internalName = internalName;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public List<String> getChildrenWindows() {
            return new ArrayList<String>(this.childrenWindows.keySet());
        }

        public void addWindow(String windowName, String uuid) {
            if (this.childrenWindows.containsKey(windowName)) {
                windowName = windowName == null ? "null" + uuid : (windowName.endsWith("|") ? windowName + "|" : windowName + windowName + " |");
            }
            this.childrenWindows.put(windowName, uuid);
        }

        public void updateWindowName(String oldWindowName, String newWindowName) {
            String windowUUID = this.getWindowUUID(oldWindowName);
            this.childrenWindows.remove(oldWindowName);
            this.childrenWindows.put(newWindowName, windowUUID);
        }

        public String getName() {
            return this.name;
        }

        public String getWindowUUID(String windowId) {
            return this.childrenWindows.get(windowId);
        }
    }
}

