/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.wsrp.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.portal.pom.data.Mapper;
import org.exoplatform.portal.pom.data.PageKey;
import org.gatein.integration.wsrp.structure.PortalStructureAccess;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;
import org.gatein.mop.api.workspace.ui.UIWindow;

public class MOPPortalStructureAccess
implements PortalStructureAccess {
    private static final String PAGES_CHILD_NAME = "pages";
    private final POMSessionManager pomManager;

    public MOPPortalStructureAccess(POMSessionManager pomManager) {
        this.pomManager = pomManager;
    }

    @Override
    public Collection<org.gatein.mop.api.workspace.Page> getPages() {
        POMSession session = this.pomManager.getSession();
        Workspace workspace = session.getWorkspace();
        Collection sites = workspace.getSites(ObjectType.PORTAL_SITE);
        ArrayList<org.gatein.mop.api.workspace.Page> pages = new ArrayList<org.gatein.mop.api.workspace.Page>(sites.size() * 10);
        for (Site site : sites) {
            org.gatein.mop.api.workspace.Page pagesRoot = this.getPagesFrom(site);
            if (pagesRoot == null) continue;
            Collection children = pagesRoot.getChildren();
            for (org.gatein.mop.api.workspace.Page child : children) {
                pages.add(child);
            }
        }
        return pages;
    }

    @Override
    public UIWindow getWindowFrom(String uuid) {
        POMSession session = this.pomManager.getSession();
        return (UIWindow)session.findObjectById(ObjectType.WINDOW, uuid);
    }

    @Override
    public void saveChangesTo(UIWindow window) {
        POMSession session = this.pomManager.getSession();
        org.gatein.mop.api.workspace.Page page = window.getPage();
        session.scheduleForEviction((Serializable)new PageKey("portal", page.getSite().getName(), page.getName()));
        session.save();
    }

    @Override
    public org.gatein.mop.api.workspace.Page getPageFrom(Page portalPage) {
        POMSession session = this.pomManager.getSession();
        Site site = session.getWorkspace().getSite(Mapper.parseSiteType((String)portalPage.getOwnerType()), portalPage.getOwnerId());
        return this.getPagesFrom(site).getChild(portalPage.getName());
    }

    @Override
    public org.gatein.mop.api.workspace.Page getPageFrom(org.exoplatform.portal.mop.page.PageKey pageKey) {
        POMSession session = this.pomManager.getSession();
        SiteKey siteKey = pageKey.getSite();
        SiteType siteType = siteKey.getType();
        String siteName = siteKey.getName();
        Site site = session.getWorkspace().getSite(Mapper.parseSiteType((String)siteType.getName()), siteName);
        return this.getPagesFrom(site).getChild(pageKey.getName());
    }

    private org.gatein.mop.api.workspace.Page getPagesFrom(Site site) {
        return site.getRootPage().getChild(PAGES_CHILD_NAME);
    }
}

