/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.wsrp.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gatein.wsrp.api.plugins.AbstractPlugins;
import org.picocontainer.Startable;

public class AS7Plugins
extends AbstractPlugins
implements Startable {
    private Map<String, List<String>> implementationNames = new HashMap<String, List<String>>(7);
    private Map<String, ClassLoader> implementationToClassLoader = new HashMap<String, ClassLoader>(7);

    protected List<String> getImplementationNamesFor(String pluginClassName, String defaultImplementationClassName) {
        List<String> names = this.getCreatedImplementationNames(pluginClassName, 1);
        if (!names.contains(defaultImplementationClassName)) {
            names.add(defaultImplementationClassName);
        }
        return names;
    }

    protected <T> Class<? extends T> getImplementationNamed(String className, Class<T> pluginClass) throws ClassNotFoundException {
        ClassLoader classLoader = this.implementationToClassLoader.get(className);
        if (classLoader == null) {
            throw new ClassNotFoundException("Couldn't find a class loader for " + className);
        }
        return classLoader.loadClass(className).asSubclass(pluginClass);
    }

    public void addPluginImplementations(String interfaceName, List<String> serviceImplementations) {
        if (serviceImplementations != null && !serviceImplementations.isEmpty()) {
            List<String> names = this.getCreatedImplementationNames(interfaceName, serviceImplementations.size());
            names.addAll(serviceImplementations);
        }
    }

    private List<String> getCreatedImplementationNames(String interfaceName, int desiredSizeIfInexistent) {
        List<String> names = this.implementationNames.get(interfaceName);
        if (names == null) {
            names = new ArrayList<String>(desiredSizeIfInexistent * 2);
            this.implementationNames.put(interfaceName, names);
        }
        return names;
    }

    public void registerClassloader(String implementation, ClassLoader classLoader) {
        this.implementationToClassLoader.put(implementation, classLoader);
    }

    public void start() {
    }

    public void stop() {
    }
}

