/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.cli.crash.commands;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.command.CRaSHCommand;
import org.crsh.command.ScriptException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class GateInCommand
extends CRaSHCommand {
    private static final Logger log = LoggerFactory.getLogger(GateInCommand.class);
    private Object conversationState;

    protected GateInCommand() throws IntrospectionException {
    }

    protected <T> T getComponent(String containerName, Class<T> componentClass) throws ScriptException {
        Object container = this.getContainer(containerName);
        try {
            Method getComponentInstanceOfTypeMethod = container.getClass().getMethod("getComponentInstanceOfType", Class.class);
            return componentClass.cast(getComponentInstanceOfTypeMethod.invoke(container, componentClass));
        }
        catch (Exception e) {
            log.error((Object)("Exception retrieving component of type " + componentClass), (Throwable)e);
            return null;
        }
    }

    protected void start(String userName, String containerName) {
        if (this.conversationState == null) {
            this.conversationState = this.getConversationState(userName, containerName);
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> conversationStateClass = cl.loadClass("org.exoplatform.services.security.ConversationState");
            Method setCurrent = conversationStateClass.getMethod("setCurrent", conversationStateClass);
            setCurrent.invoke(null, this.conversationState);
            Class<?> eXoContainerContextClass = cl.loadClass("org.exoplatform.container.ExoContainerContext");
            Class<?> eXoContainerClass = cl.loadClass("org.exoplatform.container.ExoContainer");
            Method setCurrentContainerMethod = eXoContainerContextClass.getMethod("setCurrentContainer", eXoContainerClass);
            setCurrentContainerMethod.invoke(eXoContainerContextClass, this.getContainer(containerName));
            Class<?> requestLifeCycleClass = cl.loadClass("org.exoplatform.container.component.RequestLifeCycle");
            Class<?> exoContainerClass = cl.loadClass("org.exoplatform.container.ExoContainer");
            Method beginMethod = requestLifeCycleClass.getMethod("begin", exoContainerClass, Boolean.TYPE);
            beginMethod.invoke(requestLifeCycleClass, this.getContainer(containerName), true);
        }
        catch (Exception e) {
            throw new ScriptException("Could not start gatein request lifecycle.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void end() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> requestLifeCycleClass = cl.loadClass("org.exoplatform.container.component.RequestLifeCycle");
            Method endMethod = requestLifeCycleClass.getMethod("end", new Class[0]);
            endMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            try {
                throw new ScriptException("Could not end gatein request lifecycle.", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    Class<?> eXoContainerContextClass = cl.loadClass("org.exoplatform.container.ExoContainerContext");
                    Class<?> eXoContainerClass = cl.loadClass("org.exoplatform.container.ExoContainer");
                    Method setCurrentContainerMethod = eXoContainerContextClass.getMethod("setCurrentContainer", eXoContainerClass);
                    setCurrentContainerMethod.invoke(eXoContainerContextClass, new Object[]{null});
                    throw throwable;
                }
                catch (Throwable t) {
                    log.error((Object)"Error while setting current container to null while ending request.");
                }
                throw throwable;
            }
        }
        try {
            Class<?> eXoContainerContextClass = cl.loadClass("org.exoplatform.container.ExoContainerContext");
            Class<?> eXoContainerClass = cl.loadClass("org.exoplatform.container.ExoContainer");
            Method setCurrentContainerMethod = eXoContainerContextClass.getMethod("setCurrentContainer", eXoContainerClass);
            setCurrentContainerMethod.invoke(eXoContainerContextClass, new Object[]{null});
            return;
        }
        catch (Throwable t) {
            log.error((Object)"Error while setting current container to null while ending request.");
            return;
        }
    }

    private Object getContainer(String containerName) throws ScriptException {
        Object container;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> eXoContainerContextClass = cl.loadClass("org.exoplatform.container.ExoContainerContext");
            Method getTopContainerMethod = eXoContainerContextClass.getMethod("getTopContainer", new Class[0]);
            container = getTopContainerMethod.invoke(null, new Object[0]);
            if (container != null) {
                Method getPortalContainerMethod = container.getClass().getMethod("getPortalContainer", String.class);
                container = getPortalContainerMethod.invoke(container, containerName);
            }
        }
        catch (Exception e) {
            throw new ScriptException("Could not obtain portal container for container name " + containerName, (Throwable)e);
        }
        if (container == null) {
            throw new ScriptException("Could not obtain portal container for container name " + containerName);
        }
        return container;
    }

    private Object getConversationState(String userName, String containerName) throws ScriptException {
        Object container = this.getContainer(containerName);
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Method getComponentInstanceOfTypeMethod = container.getClass().getMethod("getComponentInstanceOfType", Class.class);
            Class<?> identityRegistryClass = tccl.loadClass("org.exoplatform.services.security.IdentityRegistry");
            Method getIdentityMethod = identityRegistryClass.getMethod("getIdentity", String.class);
            Class<?> identityClass = tccl.loadClass("org.exoplatform.services.security.Identity");
            Object identityRegistry = getComponentInstanceOfTypeMethod.invoke(container, identityRegistryClass);
            Object identity = getIdentityMethod.invoke(identityRegistry, userName);
            if (identity == null) {
                Class<?> authenticatorClass = tccl.loadClass("org.exoplatform.services.security.Authenticator");
                Object authenticator = getComponentInstanceOfTypeMethod.invoke(container, authenticatorClass);
                Method createIdentityMethod = authenticatorClass.getMethod("createIdentity", String.class);
                identity = createIdentityMethod.invoke(authenticator, userName);
                Method registerIdentityMethod = identityRegistryClass.getMethod("register", identityClass);
                registerIdentityMethod.invoke(identityRegistry, identity);
            }
            Class<?> conversationStateClass = tccl.loadClass("org.exoplatform.services.security.ConversationState");
            Constructor<?> conversationStateConstructor = conversationStateClass.getConstructor(identityClass);
            return conversationStateConstructor.newInstance(identity);
        }
        catch (Exception e) {
            throw new ScriptException("Could not authenticate for user '" + userName + "'", (Throwable)e);
        }
    }
}

