/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import java.util.Map;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.PortletControllerContext;
import org.gatein.pc.controller.RequestHandler;
import org.gatein.pc.controller.request.PortletResourceRequest;
import org.gatein.pc.controller.response.ControllerResponse;
import org.gatein.pc.controller.response.ResourceResponse;
import org.gatein.pc.controller.state.PortletPageNavigationalState;
import org.gatein.pc.controller.state.PortletWindowNavigationalState;

class PortletResourceRequestHandler
extends RequestHandler<PortletResourceRequest> {
    public PortletResourceRequestHandler(PortletController controller) {
        super(PortletResourceRequest.class, controller);
    }

    @Override
    ControllerResponse processResponse(PortletControllerContext controllerContext, PortletResourceRequest request, PortletInvocationResponse response) throws PortletInvokerException {
        return new ResourceResponse(response);
    }

    @Override
    PortletInvocationResponse invoke(PortletControllerContext context, PortletResourceRequest portletResourceRequest) throws PortletInvokerException {
        CacheLevel cacheability;
        Mode mode = null;
        WindowState windowState = null;
        PortletPageNavigationalState pageNavigationalState = null;
        Map<String, String[]> publicNS = null;
        StateString portletNS = null;
        PortletResourceRequest.Scope scope = portletResourceRequest.getScope();
        if (scope instanceof PortletResourceRequest.PortletScope) {
            PortletResourceRequest.PortletScope portletScope = (PortletResourceRequest.PortletScope)scope;
            PortletWindowNavigationalState navigationalState = portletScope.getWindowNavigationalState();
            if (navigationalState != null) {
                mode = navigationalState.getMode();
                windowState = navigationalState.getWindowState();
                portletNS = navigationalState.getPortletNavigationalState();
            }
            if (scope instanceof PortletResourceRequest.PageScope) {
                PortletResourceRequest.PageScope pageScope = (PortletResourceRequest.PageScope)scope;
                pageNavigationalState = pageScope.getPageNavigationalState();
                cacheability = CacheLevel.PAGE;
                if (pageNavigationalState != null) {
                    publicNS = pageNavigationalState.getPortletPublicNavigationalState(portletResourceRequest.getWindowId());
                }
            } else {
                cacheability = CacheLevel.PORTLET;
            }
        } else {
            cacheability = CacheLevel.FULL;
        }
        if (mode == null) {
            mode = Mode.VIEW;
        }
        if (windowState == null) {
            windowState = WindowState.NORMAL;
        }
        PortletInvocationContext portletInvocationContext = context.createPortletInvocationContext(portletResourceRequest.getWindowId(), pageNavigationalState);
        ResourceInvocation resourceInvocation = new ResourceInvocation(portletInvocationContext);
        resourceInvocation.setResourceId(portletResourceRequest.getResourceId());
        resourceInvocation.setCacheLevel(cacheability);
        resourceInvocation.setMode(mode);
        resourceInvocation.setWindowState(windowState);
        resourceInvocation.setNavigationalState(portletNS);
        resourceInvocation.setPublicNavigationalState(publicNS);
        resourceInvocation.setResourceState(portletResourceRequest.getResourceState());
        resourceInvocation.setForm(portletResourceRequest.getBodyParameters() != null ? ParameterMap.clone(portletResourceRequest.getBodyParameters()) : null);
        try {
            return context.invoke(resourceInvocation);
        }
        catch (PortletInvokerException e) {
            return null;
        }
    }
}

